/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.implspi;

import java.util.EnumSet;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class SourceControl {
    private static final RequestProcessor RP = new RequestProcessor("parsing-event-collector", 1, false, false);
    private final RequestProcessor.Task resetTask;
    private final Source source;

    public SourceControl(final @NonNull Source source) {
        Parameters.notNull("source", source);
        this.source = source;
        this.resetTask = RP.create(new Runnable(){

            @Override
            public void run() {
                if (SourceAccessor.getINSTANCE().getEnv(source).isReparseBlocked()) {
                    return;
                }
                TaskProcessor.resetStateImpl(source);
            }
        });
    }

    @NonNull
    public Source getSource() {
        return this.source;
    }

    public void sourceChanged(boolean mimeChanged) {
        SourceAccessor sa = SourceAccessor.getINSTANCE();
        EnumSet<SourceFlags> flags = EnumSet.of(SourceFlags.CHANGE_EXPECTED, SourceFlags.INVALID, SourceFlags.RESCHEDULE_FINISHED_TASKS);
        if (mimeChanged) {
            sa.mimeTypeMayChanged(this.source);
        }
        sa.setSourceModification(this.source, true, -1, -1);
        sa.setFlags(this.source, flags);
        TaskProcessor.resetState(this.source, true, true);
    }

    public void regionChanged(int startOffset, int endOffset) {
        SourceAccessor sa = SourceAccessor.getINSTANCE();
        EnumSet<SourceFlags> flags = EnumSet.of(SourceFlags.CHANGE_EXPECTED, SourceFlags.INVALID, SourceFlags.RESCHEDULE_FINISHED_TASKS);
        sa.setSourceModification(this.source, true, startOffset, endOffset);
        sa.setFlags(this.source, flags);
        TaskProcessor.resetState(this.source, true, true);
    }

    public void stateChanged() {
        SourceAccessor sa = SourceAccessor.getINSTANCE();
        EnumSet<SourceFlags> flags = EnumSet.of(SourceFlags.CHANGE_EXPECTED);
        sa.setSourceModification(this.source, false, -1, -1);
        sa.setFlags(this.source, flags);
        TaskProcessor.resetState(this.source, false, true);
    }

    public void revalidate(int delay) {
        this.resetTask.schedule(delay);
    }
}

