/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.locations;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.internal.scanner.ReadOnlyLocationHandler;
import org.flywaydb.core.internal.util.Pair;

public class LocationParser {
    private static final String LOCATION_SEPARATOR = ":";
    private static final Pattern FILE_PATH_WITH_DRIVE_PATTERN = Pattern.compile("^[A-Za-z]:[\\\\/].*");
    private static final Pattern FILE_URL_PATTERN = Pattern.compile("^file:[\\\\/]{3}.*");

    public static Location parseLocation(String descriptor) {
        return LocationParser.parseLocation(descriptor, "classpath:", new ReadOnlyLocationHandler[0]);
    }

    public static Location parseLocation(String descriptor, String defaultPrefix, ReadOnlyLocationHandler ... additionalLocationHandlers) {
        String normalizedDescriptor = descriptor.trim();
        Pair<String, String> parsedDescriptor = LocationParser.parseDescriptor(normalizedDescriptor, defaultPrefix);
        String prefix = parsedDescriptor.getLeft();
        String rawPath = parsedDescriptor.getRight();
        List<ReadOnlyLocationHandler> locationHandlers = Stream.concat(Flyway.configure().getPluginRegister().getInstancesOf(ReadOnlyLocationHandler.class).stream(), Arrays.stream(additionalLocationHandlers)).toList();
        ReadOnlyLocationHandler locationHandler = locationHandlers.stream().filter(x -> prefix.equalsIgnoreCase(x.getPrefix())).findFirst().orElseThrow(() -> new FlywayException("Unknown prefix for location (should be one of " + locationHandlers.stream().map(ReadOnlyLocationHandler::getPrefix).collect(Collectors.joining(", ")) + "): " + normalizedDescriptor));
        return locationHandler.handlesWildcards() && LocationParser.containsWildcards(rawPath) ? LocationParser.parseWildcardLocation(rawPath, locationHandler.getPrefix(), locationHandler.getPathSeparator(), locationHandler::normalizePath) : Location.fromPath(locationHandler.getPrefix(), locationHandler.normalizePath(rawPath));
    }

    private static Pair<String, String> parseDescriptor(String descriptor, String defaultPrefix) {
        String path;
        String prefix;
        if (descriptor.contains(LOCATION_SEPARATOR) && !FILE_PATH_WITH_DRIVE_PATTERN.matcher(descriptor).matches() && !FILE_URL_PATTERN.matcher(descriptor).matches()) {
            prefix = descriptor.substring(0, descriptor.indexOf(LOCATION_SEPARATOR) + 1);
            path = descriptor.substring(descriptor.indexOf(LOCATION_SEPARATOR) + 1);
        } else {
            prefix = defaultPrefix;
            path = descriptor;
        }
        return Pair.of(prefix, path);
    }

    private static boolean containsWildcards(String rawPath) {
        return rawPath.contains("*") || rawPath.contains("?");
    }

    private static Location parseWildcardLocation(String rawPath, String prefix, String separator, Function<? super String, String> normalizePath) {
        String escapedSeparator = separator.replace("\\", "\\\\").replace("/", "\\/");
        String[] pathSplit = rawPath.split("[\\\\/]");
        StringBuilder rootPart = new StringBuilder();
        StringBuilder patternPart = new StringBuilder();
        boolean endsInFile = false;
        boolean skipSeparator = false;
        boolean inPattern = false;
        for (String pathPart : pathSplit) {
            endsInFile = false;
            if (pathPart.contains("*") || pathPart.contains("?")) {
                inPattern = true;
            }
            if (inPattern) {
                String regex;
                if (skipSeparator) {
                    skipSeparator = false;
                } else {
                    patternPart.append("/");
                }
                if ("**".equals(pathPart)) {
                    regex = "([^/]+/)*?";
                    skipSeparator = true;
                } else {
                    endsInFile = pathPart.contains(".");
                    regex = pathPart;
                    regex = regex.replace(".", "\\.");
                    regex = regex.replace("?", "[^/]");
                    regex = regex.replace("*", "[^/]+?");
                }
                patternPart.append(regex);
                continue;
            }
            rootPart.append(separator).append(pathPart);
        }
        String rootPath = normalizePath.apply(!rootPart.isEmpty() ? rootPart.substring(1) : "");
        Object pattern = patternPart.substring(1);
        pattern = ((String)pattern).replace("/", escapedSeparator);
        if (!rootPart.isEmpty()) {
            pattern = rootPath.replace(separator, escapedSeparator) + escapedSeparator + (String)pattern;
        }
        if (!endsInFile) {
            pattern = (String)pattern + escapedSeparator + "(?<relpath>.*)";
        }
        Pattern pathRegex = Pattern.compile((String)pattern);
        return Location.fromWildcardPath(prefix, rootPath, rawPath, pathRegex);
    }
}

