/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

public final class Relationship
implements Comparable<Relationship> {
    public static final Relationship SELF = new Builder().build();
    public static final Relationship ANONYMOUS = new Builder().name("").build();
    private final String name;
    private final String description;
    private final int hashCode;
    private final boolean isAutoTerminate;

    protected Relationship(Builder builder) {
        this.name = builder.name == null ? null : builder.name.intern();
        this.description = builder.description;
        this.isAutoTerminate = builder.autoTerminate;
        this.hashCode = 301 + (this.name == null ? 0 : this.name.hashCode());
    }

    @Override
    public int compareTo(Relationship o) {
        if (o == null) {
            return -1;
        }
        String thisName = this.getName();
        String thatName = o.getName();
        if (thisName == null && thatName == null) {
            return 0;
        }
        if (thisName == null) {
            return 1;
        }
        if (thatName == null) {
            return -1;
        }
        return thisName.compareTo(thatName);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAutoTerminated() {
        return this.isAutoTerminate;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Relationship)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Relationship desc = (Relationship)other;
        return this.name.equals(desc.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    public static final class Builder {
        private String name = "";
        private String description = "";
        private boolean autoTerminate = false;

        public Builder name(String name) {
            if (null != name) {
                this.name = name;
            }
            return this;
        }

        public Builder description(String description) {
            if (null != description) {
                this.description = description;
            }
            return this;
        }

        public Builder autoTerminateDefault(boolean autoTerminate) {
            this.autoTerminate = autoTerminate;
            return this;
        }

        public Relationship build() {
            return new Relationship(this);
        }
    }
}

