# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

function(get_rocksdb SOURCE_DIR BINARY_DIR)
    if(MINIFI_ROCKSDB_SOURCE STREQUAL "CONAN")
        message("Using Conan to install RocksDB")
        find_package(RocksDB REQUIRED)
        add_library(RocksDB::RocksDB ALIAS RocksDB::rocksdb)
    elseif(MINIFI_ROCKSDB_SOURCE STREQUAL "BUILD")
        message("Using CMake to build RocksDB from source")

        if (BUILD_ROCKSDB)
            include(BundledRocksDB)
            use_bundled_rocksdb(${SOURCE_DIR} ${BINARY_DIR})
        else()
            list(APPEND CMAKE_MODULE_PATH "${SOURCE_DIR}/cmake/rocksdb/sys")
            find_package(RocksDB REQUIRED)
        endif()
    endif()
endfunction(get_rocksdb SOURCE_DIR BINARY_DIR)
