/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.nio.ByteBuffer;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.executor.CoarseGrainedExecutorBackend;
import org.apache.spark.executor.ExecutorBackend;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.shuffle.BlockPushingListener;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.ShuffleBlockPusher$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShufflePushBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00115a!B/_\u0001\u00014\u0007\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u000be\u0004A\u0011\u0001>\t\ry\u0004\u0001\u0015!\u0003\u0000\u0011\u001d\t)\u0001\u0001Q\u0001\n}Dq!a\u0002\u0001A\u0003%q\u0010\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0006\u0011!\t\t\u0002\u0001Q\u0001\n\u0005-\u0001BCA\n\u0001\u0001\u0007I\u0011\u00010\u0002\u0016!Q\u0011q\u0003\u0001A\u0002\u0013\u0005a,!\u0007\t\u000f\u0005\u0015\u0002\u0001)Q\u0005\u007f\"A\u0011q\u0005\u0001!B\u0013\tY\u0001\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0016\u0011!\t9\u0005\u0001Q\u0001\n\u0005%\u0003\u0002CB\u0002\u0001\u0001\u0006I!a\u0013\t\u0011\r\u0015\u0001\u0001)A\u0005\u0007\u000fA!ba\b\u0001\u0005\u0004%\tAXB\u0011\u0011!\u0019I\u0003\u0001Q\u0001\n\r\r\u0002\u0002CB\u0016\u0001\u0001\u0006K!a\u0003\t\u0011\r5\u0002\u0001)Q\u0005\u0003\u0017A\u0001ba\f\u0001A\u0003&\u00111\u0002\u0005\t\u0007c\u0001\u0001\u0015)\u0003\u00036!A11\u0007\u0001\u0005\u0002y\u001b)\u0004\u0003\u0005\u00048\u0001!\tAXB\u001d\u0011!\u0019Y\u0004\u0001C\u0001=\u000eu\u0002\u0002CBB\u0001\u0011\u0005al!\u0001\t\u000f\r\u0015\u0005\u0001\"\u0005\u0004\b\"911\u0013\u0001\u0005\n\r\u0005\u0001bBBK\u0001\u0011%1q\u0013\u0005\b\u0007;\u0003A\u0011BBP\u0011\u001d\u0019Y\u000b\u0001C\u0005\u0007[Cqa!1\u0001\t#\u0019\t\u0001\u0003\u0005\u0004D\u0002!\tAXBc\u0011\u001d\u0019i\u000f\u0001C\t\u0007_<\u0001\"a\u001b_\u0011\u0003\u0001\u0017Q\u000e\u0004\b;zC\t\u0001YA8\u0011\u0019I8\u0005\"\u0001\u0002r\u00199\u00111O\u0012AA\u0006U\u0004BCABK\tU\r\u0011\"\u0001\u0002\u0006\"Q\u0011qQ\u0013\u0003\u0012\u0003\u0006I!a\u000f\t\u0015\u0005%UE!f\u0001\n\u0003\tY\t\u0003\u0006\u0002,\u0016\u0012\t\u0012)A\u0005\u0003\u001bC!\"!,&\u0005+\u0007I\u0011AAX\u0011)\t\t-\nB\tB\u0003%\u0011\u0011\u0017\u0005\u0007s\u0016\"\t!a1\t\u0013\u0005=WE1A\u0005\u0002\u0005E\u0007\u0002CAjK\u0001\u0006I!a\u0003\t\u0013\u0005UW%!A\u0005\u0002\u0005]\u0007\"CApKE\u0005I\u0011AAq\u0011%\t90JI\u0001\n\u0003\tI\u0010C\u0005\u0002~\u0016\n\n\u0011\"\u0001\u0002\u0000\"I!1A\u0013\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005/)\u0013\u0011!C\u0001\u0003#D\u0011B!\u0007&\u0003\u0003%\tAa\u0007\t\u0013\t\u0015R%!A\u0005B\t\u001d\u0002\"\u0003B\u0019K\u0005\u0005I\u0011\u0001B\u001a\u0011%\u0011i$JA\u0001\n\u0003\u0012y\u0004C\u0005\u0003B\u0015\n\t\u0011\"\u0011\u0003D!I!QI\u0013\u0002\u0002\u0013\u0005#qI\u0004\u000b\u0005\u0017\u001a\u0013\u0011!E\u0001A\n5cACA:G\u0005\u0005\t\u0012\u00011\u0003P!1\u0011\u0010\u0010C\u0001\u0005;B\u0011B!\u0011=\u0003\u0003%)Ea\u0011\t\u0013\t}C(!A\u0005\u0002\n\u0005\u0004\"\u0003B5y\u0005\u0005I\u0011\u0011B6\u0011%\u0011i\bPA\u0001\n\u0013\u0011yH\u0002\u0004\u0003\b\u000e\"%\u0011\u0012\u0005\u000b\u0005\u0017\u0013%Q3A\u0005\u0002\t5\u0005B\u0003BO\u0005\nE\t\u0015!\u0003\u0003\u0010\"Q!q\u0014\"\u0003\u0016\u0004%\tA!)\t\u0015\t%&I!E!\u0002\u0013\u0011\u0019\u000b\u0003\u0004z\u0005\u0012\u0005!1\u0016\u0005\n\u0003+\u0014\u0015\u0011!C\u0001\u0005gC\u0011\"a8C#\u0003%\tA!/\t\u0013\u0005]()%A\u0005\u0002\tu\u0006\"\u0003B\u0002\u0005\u0006\u0005I\u0011\tB\u0003\u0011%\u00119BQA\u0001\n\u0003\t\t\u000eC\u0005\u0003\u001a\t\u000b\t\u0011\"\u0001\u0003B\"I!Q\u0005\"\u0002\u0002\u0013\u0005#q\u0005\u0005\n\u0005c\u0011\u0015\u0011!C\u0001\u0005\u000bD\u0011B!\u0010C\u0003\u0003%\tEa\u0010\t\u0013\t\u0005#)!A\u0005B\t\r\u0003\"\u0003B#\u0005\u0006\u0005I\u0011\tBe\u000f%\u0011imIA\u0001\u0012\u0013\u0011yMB\u0005\u0003\b\u000e\n\t\u0011#\u0003\u0003R\"1\u0011\u0010\u0016C\u0001\u00053D\u0011B!\u0011U\u0003\u0003%)Ea\u0011\t\u0013\t}C+!A\u0005\u0002\nm\u0007\"\u0003B5)\u0006\u0005I\u0011\u0011Bq\u0011%\u0011i\bVA\u0001\n\u0013\u0011y\bC\u0005\u0003j\u000e\u0012\r\u0011\"\u0003\u0003l\"A!Q`\u0012!\u0002\u0013\u0011i\u000f\u0003\u0005\u0003\u0000\u000e\"\t\u0001YB\u0001\u0005I\u0019\u0006.\u001e4gY\u0016\u0014En\\2l!V\u001c\b.\u001a:\u000b\u0005}\u0003\u0017aB:ik\u001a4G.\u001a\u0006\u0003C\n\fQa\u001d9be.T!a\u00193\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0017aA8sON\u0019\u0001aZ7\u0011\u0005!\\W\"A5\u000b\u0003)\fQa]2bY\u0006L!\u0001\\5\u0003\r\u0005s\u0017PU3g!\tq\u0017/D\u0001p\u0015\t\u0001\b-\u0001\u0005j]R,'O\\1m\u0013\t\u0011xNA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gNZ\u0002\u0001!\t1x/D\u0001a\u0013\tA\bMA\u0005Ta\u0006\u00148nQ8oM\u00061A(\u001b8jiz\"\"a_?\u0011\u0005q\u0004Q\"\u00010\t\u000bM\u0014\u0001\u0019A;\u0002%5\f\u0007P\u00117pG.\u001c\u0016N_3U_B+8\u000f\u001b\t\u0004Q\u0006\u0005\u0011bAA\u0002S\n!Aj\u001c8h\u0003Ei\u0017\r\u001f\"m_\u000e\\')\u0019;dQNK'0Z\u0001\u0011[\u0006D()\u001f;fg&sg\t\\5hQR\fq\"\\1y%\u0016\f8/\u00138GY&<\u0007\u000e\u001e\t\u0004Q\u00065\u0011bAA\bS\n\u0019\u0011J\u001c;\u000275\f\u0007P\u00117pG.\u001c\u0018J\u001c$mS\u001eDG\u000fU3s\u0003\u0012$'/Z:t\u00035\u0011\u0017\u0010^3t\u0013:4E.[4iiV\tq0A\tcsR,7/\u00138GY&<\u0007\u000e^0%KF$B!a\u0007\u0002\"A\u0019\u0001.!\b\n\u0007\u0005}\u0011N\u0001\u0003V]&$\b\u0002CA\u0012\u0013\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'\u0001\bcsR,7/\u00138GY&<\u0007\u000e\u001e\u0011\u0002\u0019I,\u0017o]%o\r2Lw\r\u001b;\u000279,XN\u00117pG.\u001c\u0018J\u001c$mS\u001eDG\u000fU3s\u0003\u0012$'/Z:t!!\ti#a\u000e\u0002<\u0005-QBAA\u0018\u0015\u0011\t\t$a\r\u0002\u000f5,H/\u00192mK*\u0019\u0011QG5\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0005=\"a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t1\u0002\u000fM$xN]1hK&!\u0011QIA \u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\fA\u0003Z3gKJ\u0014X\r\u001a)vg\"\u0014V-];fgR\u001c\b\u0003CA\u0017\u0003o\tY$a\u0013\u0011\r\u00055\u0012QJA)\u0013\u0011\ty%a\f\u0003\u000bE+X-^3\u0011\u0007\u0005MSED\u0002\u0002V\trA!a\u0016\u0002j9!\u0011\u0011LA4\u001d\u0011\tY&!\u001a\u000f\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019u\u0003\u0019a$o\\8u}%\tQ-\u0003\u0002dI&\u0011\u0011MY\u0005\u0003?\u0002\f!c\u00155vM\u001adWM\u00117pG.\u0004Vo\u001d5feB\u0011ApI\n\u0003G\u001d$\"!!\u001c\u0003\u0017A+8\u000f\u001b*fcV,7\u000f^\n\u0007K\u001d\f9(! \u0011\u0007!\fI(C\u0002\u0002|%\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002i\u0003\u007fJ1!!!j\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\tG\r\u001a:fgN,\"!a\u000f\u0002\u0011\u0005$GM]3tg\u0002\naA\u00197pG.\u001cXCAAG!\u0019\ty)!'\u0002 :!\u0011\u0011SAK\u001d\u0011\ti&a%\n\u0003)L1!a&j\u0003\u001d\u0001\u0018mY6bO\u0016LA!a'\u0002\u001e\n\u00191+Z9\u000b\u0007\u0005]\u0015\u000eE\u0004i\u0003C\u000b)+a\u0003\n\u0007\u0005\r\u0016N\u0001\u0004UkBdWM\r\t\u0005\u0003{\t9+\u0003\u0003\u0002*\u0006}\"a\u0002\"m_\u000e\\\u0017\nZ\u0001\bE2|7m[:!\u0003%\u0011X-\u001d\"vM\u001a,'/\u0006\u0002\u00022B!\u00111WA_\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016A\u00022vM\u001a,'OC\u0002\u0002<\u0002\fqA\\3uo>\u00148.\u0003\u0003\u0002@\u0006U&!D'b]\u0006<W\r\u001a\"vM\u001a,'/\u0001\u0006sKF\u0014UO\u001a4fe\u0002\"\u0002\"!2\u0002J\u0006-\u0017Q\u001a\t\u0004\u0003\u000f,S\"A\u0012\t\u000f\u0005\rE\u00061\u0001\u0002<!9\u0011\u0011\u0012\u0017A\u0002\u00055\u0005bBAWY\u0001\u0007\u0011\u0011W\u0001\u0005g&TX-\u0006\u0002\u0002\f\u0005)1/\u001b>fA\u0005!1m\u001c9z)!\t)-!7\u0002\\\u0006u\u0007\"CAB_A\u0005\t\u0019AA\u001e\u0011%\tIi\fI\u0001\u0002\u0004\ti\tC\u0005\u0002.>\u0002\n\u00111\u0001\u00022\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAArU\u0011\tY$!:,\u0005\u0005\u001d\b\u0003BAu\u0003gl!!a;\u000b\t\u00055\u0018q^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!=j\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\fYOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002|*\"\u0011QRAs\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u0001+\t\u0005E\u0016Q]\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u001d\u0001\u0003\u0002B\u0005\u0005'i!Aa\u0003\u000b\t\t5!qB\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0012\u0005!!.\u0019<b\u0013\u0011\u0011)Ba\u0003\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\b\u0003$A\u0019\u0001Na\b\n\u0007\t\u0005\u0012NA\u0002B]fD\u0011\"a\t6\u0003\u0003\u0005\r!a\u0003\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u000b\u0011\r\t-\"Q\u0006B\u000f\u001b\t\t\u0019$\u0003\u0003\u00030\u0005M\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u000e\u0003<A\u0019\u0001Na\u000e\n\u0007\te\u0012NA\u0004C_>dW-\u00198\t\u0013\u0005\rr'!AA\u0002\tu\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005-\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u001d\u0011AB3rk\u0006d7\u000f\u0006\u0003\u00036\t%\u0003\"CA\u0012u\u0005\u0005\t\u0019\u0001B\u000f\u0003-\u0001Vo\u001d5SKF,Xm\u001d;\u0011\u0007\u0005\u001dGhE\u0003=\u0005#\ni\b\u0005\u0007\u0003T\te\u00131HAG\u0003c\u000b)-\u0004\u0002\u0003V)\u0019!qK5\u0002\u000fI,h\u000e^5nK&!!1\fB+\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005\u001b\nQ!\u00199qYf$\u0002\"!2\u0003d\t\u0015$q\r\u0005\b\u0003\u0007{\u0004\u0019AA\u001e\u0011\u001d\tIi\u0010a\u0001\u0003\u001bCq!!,@\u0001\u0004\t\t,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5$\u0011\u0010\t\u0006Q\n=$1O\u0005\u0004\u0005cJ'AB(qi&|g\u000eE\u0005i\u0005k\nY$!$\u00022&\u0019!qO5\u0003\rQ+\b\u000f\\34\u0011%\u0011Y\bQA\u0001\u0002\u0004\t)-A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0011\t\u0005\u0005\u0013\u0011\u0019)\u0003\u0003\u0003\u0006\n-!AB(cU\u0016\u001cGO\u0001\u0006QkND'+Z:vYR\u001cbAQ4\u0002x\u0005u\u0014a\u00022m_\u000e\\\u0017\nZ\u000b\u0003\u0005\u001f\u0003BA!%\u0003\u001a:!!1\u0013BK!\r\ti&[\u0005\u0004\u0005/K\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0016\tm%b\u0001BLS\u0006A!\r\\8dW&#\u0007%A\u0004gC&dWO]3\u0016\u0005\t\r\u0006\u0003BAH\u0005KKAAa*\u0002\u001e\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\tM\u0006LG.\u001e:fAQ1!Q\u0016BX\u0005c\u00032!a2C\u0011\u001d\u0011Yi\u0012a\u0001\u0005\u001fCqAa(H\u0001\u0004\u0011\u0019\u000b\u0006\u0004\u0003.\nU&q\u0017\u0005\n\u0005\u0017C\u0005\u0013!a\u0001\u0005\u001fC\u0011Ba(I!\u0003\u0005\rAa)\u0016\u0005\tm&\u0006\u0002BH\u0003K,\"Aa0+\t\t\r\u0016Q\u001d\u000b\u0005\u0005;\u0011\u0019\rC\u0005\u0002$5\u000b\t\u00111\u0001\u0002\fQ!!Q\u0007Bd\u0011%\t\u0019cTA\u0001\u0002\u0004\u0011i\u0002\u0006\u0003\u00036\t-\u0007\"CA\u0012%\u0006\u0005\t\u0019\u0001B\u000f\u0003)\u0001Vo\u001d5SKN,H\u000e\u001e\t\u0004\u0003\u000f$6#\u0002+\u0003T\u0006u\u0004C\u0003B*\u0005+\u0014yIa)\u0003.&!!q\u001bB+\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005\u001f$bA!,\u0003^\n}\u0007b\u0002BF/\u0002\u0007!q\u0012\u0005\b\u0005?;\u0006\u0019\u0001BR)\u0011\u0011\u0019Oa:\u0011\u000b!\u0014yG!:\u0011\u000f!\f\tKa$\u0003$\"I!1\u0010-\u0002\u0002\u0003\u0007!QV\u0001\u0012\u00052{5iS0Q+NCUIU0Q\u001f>cUC\u0001Bw!\u0011\u0011yO!?\u000e\u0005\tE(\u0002\u0002Bz\u0005k\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\u00119Pa\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0014\tPA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003I\u0011EjT\"L?B+6\u000bS#S?B{u\n\u0014\u0011\u0002\tM$x\u000e\u001d\u000b\u0003\u00037\tA\u0002];tQJ+\u0017/^3tiN\fA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004Ba!\u0003\u0004\u001a9!11BB\n\u001d\u0011\u0019ia!\u0005\u000f\t\u0005]3qB\u0005\u0004\u0003w\u0003\u0017bA0\u0002:&!1QCB\f\u00031)%O]8s\u0011\u0006tG\r\\3s\u0015\ry\u0016\u0011X\u0005\u0005\u00077\u0019iBA\u000bCY>\u001c7\u000eU;tQ\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\t\rU1qC\u0001\u0015k:\u0014X-Y2iC\ndWM\u00117pG.luM]:\u0016\u0005\r\r\u0002CBA\u0017\u0007K\tY$\u0003\u0003\u0004(\u0005=\"a\u0002%bg\"\u001cV\r^\u0001\u0016k:\u0014X-Y2iC\ndWM\u00117pG.luM]:!\u0003%\u0019\b.\u001e4gY\u0016LE-\u0001\u0005nCBLe\u000eZ3y\u00039\u0019\b.\u001e4gY\u0016lUM]4f\u0013\u0012\fa\u0003];tQ\u000e{W\u000e\u001d7fi&|gNT8uS\u001aLW\rZ\u0001\u0013GJ,\u0017\r^3FeJ|'\u000fS1oI2,'\u000f\u0006\u0002\u0004\b\u0005A\u0012n\u001d)vg\"\u001cu.\u001c9mKRLwN\u001c(pi&4\u0017.\u001a3\u0016\u0005\tU\u0012!E5oSRL\u0017\r^3CY>\u001c7\u000eU;tQRQ\u00111DB \u0007\u001f\u001aIf!!\t\u000f\r\u0005\u0003\u00041\u0001\u0004D\u0005AA-\u0019;b\r&dW\r\u0005\u0003\u0004F\r-SBAB$\u0015\u0011\u0019IEa\u0004\u0002\u0005%|\u0017\u0002BB'\u0007\u000f\u0012AAR5mK\"91\u0011\u000b\rA\u0002\rM\u0013\u0001\u00059beRLG/[8o\u0019\u0016tw\r\u001e5t!\u0011A7QK@\n\u0007\r]\u0013NA\u0003BeJ\f\u0017\u0010C\u0004\u0004\\a\u0001\ra!\u0018\u0002\u0007\u0011,\u0007\u000f\r\u0005\u0004`\r%4qOB?!%18\u0011MB3\u0007k\u001aY(C\u0002\u0004d\u0001\u0014\u0011c\u00155vM\u001adW\rR3qK:$WM\\2z!\u0011\u00199g!\u001b\r\u0001\u0011a11NB-\u0003\u0003\u0005\tQ!\u0001\u0004n\t\u0019q\fJ\u0019\u0012\t\r=$Q\u0004\t\u0004Q\u000eE\u0014bAB:S\n9aj\u001c;iS:<\u0007\u0003BB4\u0007o\"Ab!\u001f\u0004Z\u0005\u0005\t\u0011!B\u0001\u0007[\u00121a\u0018\u00133!\u0011\u00199g! \u0005\u0019\r}4\u0011LA\u0001\u0002\u0003\u0015\ta!\u001c\u0003\u0007}#3\u0007C\u0004\u0004.a\u0001\r!a\u0003\u0002\u001dQ\u0014\u0018\u0010U;tQV\u0003Hk\\'bq\u0006Q1/\u001e2nSR$\u0016m]6\u0015\t\u0005m1\u0011\u0012\u0005\b\u0007\u0017S\u0002\u0019ABG\u0003\u0011!\u0018m]6\u0011\t\t%1qR\u0005\u0005\u0007#\u0013YA\u0001\u0005Sk:t\u0017M\u00197f\u0003-\u0001Xo\u001d5VaR{W*\u0019=\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005\u00037\u0019I\nC\u0004\u0004\u001cr\u0001\r!!\u0015\u0002\u000fI,\u0017/^3ti\u0006q2\u000f\\5dKJ+\u0017OQ;gM\u0016\u0014\u0018J\u001c;p\u00052|7m\u001b\"vM\u001a,'o\u001d\u000b\u0007\u0007C\u001b\u0019k!*\u0011\u000b!\u001c)&!-\t\u000f\u00055V\u00041\u0001\u00022\"91qU\u000fA\u0002\r%\u0016A\u00032m_\u000e\\7+\u001b>fgB1\u0011qRAM\u0003\u0017\tQ$\u001e9eCR,7\u000b^1uK\u0006sGm\u00115fG.Le\rU;tQ6{'/\u001a\u000b\u000b\u0005k\u0019yka-\u00046\u000em\u0006BBBY=\u0001\u0007q0A\u0006csR,7\u000fU;tQ\u0016$\u0007bBAB=\u0001\u0007\u00111\b\u0005\b\u0007os\u0002\u0019AB]\u0003=\u0011X-\\1j]&twM\u00117pG.\u001c\bCBA\u0017\u0007K\u0011y\tC\u0004\u0004>z\u0001\raa0\u0002\u0015A,8\u000f\u001b*fgVdG\u000fE\u0002\u0002T\t\u000bqD\\8uS\u001aLHI]5wKJ\f%m\\;u!V\u001c\bnQ8na2,G/[8o\u0003a\u0001(/\u001a9be\u0016\u0014En\\2l!V\u001c\bNU3rk\u0016\u001cHo\u001d\u000b\u0013\u0007\u000f\u001cIm!4\u0004R\u000eM7Q[Bl\u00073\u001cy\u000e\u0005\u0004\u0002\u0010\u0006e\u0015\u0011\u000b\u0005\b\u0007\u0017\u0004\u0003\u0019AA\u0006\u00035qW/\u001c)beRLG/[8og\"91q\u001a\u0011A\u0002\u0005-\u0011a\u00039beRLG/[8o\u0013\u0012Dqaa\u000b!\u0001\u0004\tY\u0001C\u0004\u00040\u0001\u0002\r!a\u0003\t\u000f\r\u0005\u0003\u00051\u0001\u0004D!91\u0011\u000b\u0011A\u0002\rM\u0003bBBnA\u0001\u00071Q\\\u0001\u000b[\u0016\u0014x-\u001a:M_\u000e\u001c\bCBAH\u00033\u000bY\u0004C\u0004\u0004b\u0002\u0002\raa9\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g!\u0011\u0019)o!;\u000e\u0005\r\u001d(\u0002\u0002B|\u0003sKAaa;\u0004h\niAK]1ogB|'\u000f^\"p]\u001a\f1c\u0019:fCR,'+Z9vKN$()\u001e4gKJ$\"\"!-\u0004r\u000eM8Q_B}\u0011\u0019\u0019\u0018\u00051\u0001\u0004d\"91\u0011I\u0011A\u0002\r\r\u0003BBB|C\u0001\u0007q0\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\u0007\u0007w\f\u0003\u0019A@\u0002\r1,gn\u001a;iQ\u0015\u00011q C\u0005!\u0011!\t\u0001\"\u0002\u000e\u0005\u0011\r!bAAyA&!Aq\u0001C\u0002\u0005\u0015\u0019\u0016N\\2fC\t!Y!A\u00034]Ir\u0003\u0007")
public class ShuffleBlockPusher
implements Logging {
    private final SparkConf conf;
    private final long maxBlockSizeToPush;
    private final long maxBlockBatchSize;
    private final long maxBytesInFlight;
    private final int maxReqsInFlight;
    private final int maxBlocksInFlightPerAddress;
    private long bytesInFlight;
    private int reqsInFlight;
    private final HashMap<BlockManagerId, Object> numBlocksInFlightPerAddress;
    private final HashMap<BlockManagerId, Queue<PushRequest>> deferredPushRequests;
    private final Queue<PushRequest> pushRequests;
    public final ErrorHandler.BlockPushErrorHandler org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler;
    private final HashSet<BlockManagerId> unreachableBlockMgrs;
    private int shuffleId;
    private int mapIndex;
    private int shuffleMergeId;
    private boolean pushCompletionNotified;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long bytesInFlight() {
        return this.bytesInFlight;
    }

    public void bytesInFlight_$eq(long x$1) {
        this.bytesInFlight = x$1;
    }

    public HashSet<BlockManagerId> unreachableBlockMgrs() {
        return this.unreachableBlockMgrs;
    }

    public ErrorHandler.BlockPushErrorHandler createErrorHandler() {
        return new ErrorHandler.BlockPushErrorHandler(null){

            public boolean shouldRetryError(Throwable t) {
                if (t.getCause() != null && t.getCause() instanceof FileNotFoundException) {
                    return false;
                }
                return !(t instanceof BlockPushNonFatalFailure) || !BlockPushNonFatalFailure.shouldNotRetryErrorCode((BlockPushNonFatalFailure.ReturnCode)((BlockPushNonFatalFailure)t).getReturnCode());
            }
        };
    }

    public boolean isPushCompletionNotified() {
        return this.pushCompletionNotified;
    }

    public void initiateBlockPush(File dataFile, long[] partitionLengths, ShuffleDependency<?, ?, ?> dep, int mapIndex) {
        int numPartitions = dep.partitioner().numPartitions();
        TransportConf transportConf = SparkTransportConf$.MODULE$.fromSparkConf(this.conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        this.shuffleId = dep.shuffleId();
        this.shuffleMergeId = dep.shuffleMergeId();
        this.mapIndex = mapIndex;
        Seq<PushRequest> requests = this.prepareBlockPushRequests(numPartitions, mapIndex, dep.shuffleId(), dep.shuffleMergeId(), dataFile, partitionLengths, dep.getMergerLocs(), transportConf);
        this.pushRequests.$plus$plus$eq(Utils$.MODULE$.randomize(requests, ClassTag$.MODULE$.apply(PushRequest.class)));
        if (this.pushRequests.isEmpty()) {
            this.notifyDriverAboutPushCompletion();
            return;
        }
        this.submitTask(() -> this.tryPushUpToMax());
    }

    public void tryPushUpToMax() {
        try {
            this.pushUpToMax();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failure during push so stopping the block push", e);
            }
            throw throwable;
        }
    }

    public void submitTask(Runnable task) {
        if (ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL() != null && !ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL().isShutdown()) {
            ShuffleBlockPusher$.MODULE$.org$apache$spark$shuffle$ShuffleBlockPusher$$BLOCK_PUSHER_POOL().execute(task);
            return;
        }
    }

    private synchronized void pushUpToMax() {
        if (this.deferredPushRequests.nonEmpty()) {
            this.deferredPushRequests.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ShuffleBlockPusher.$anonfun$pushUpToMax$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ShuffleBlockPusher.$anonfun$pushUpToMax$2(this, x$1);
                return BoxedUnit.UNIT;
            });
        }
        while (this.isRemoteBlockPushable$1(this.pushRequests)) {
            PushRequest request = (PushRequest)this.pushRequests.dequeue();
            BlockManagerId remoteAddress = request.address();
            if (this.isRemoteAddressMaxedOut$1(remoteAddress, request)) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Deferring push request for ").append(remoteAddress).append(" with ").append(request.blocks().size()).append(" blocks").toString());
                ((Queue)this.deferredPushRequests.getOrElseUpdate((Object)remoteAddress, (Function0 & Serializable & scala.Serializable)() -> new Queue())).enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PushRequest[]{request}));
                continue;
            }
            this.sendRequest(request);
        }
    }

    private void sendRequest(PushRequest request) {
        this.bytesInFlight_$eq(this.bytesInFlight() + (long)request.size());
        ++this.reqsInFlight;
        this.numBlocksInFlightPerAddress.update((Object)request.address(), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.getOrElseUpdate((Object)request.address(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + request.blocks().length())));
        Map sizeMap = ((TraversableOnce)request.blocks().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlockId blockId = (BlockId)tuple2._1();
                int size = tuple2._2$mcI$sp();
                return new Tuple2((Object)blockId.toString(), (Object)BoxesRunTime.boxToInteger((int)size));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        BlockManagerId address = request.address();
        Seq blockIds = (Seq)request.blocks().map((Function1 & Serializable & scala.Serializable)x$2 -> ((BlockId)x$2._1()).toString(), Seq$.MODULE$.canBuildFrom());
        HashSet remainingBlocks = (HashSet)new HashSet().$plus$plus$eq((TraversableOnce)blockIds);
        BlockPushingListener blockPushListener = new BlockPushingListener(this, sizeMap, address, remainingBlocks){
            private final /* synthetic */ ShuffleBlockPusher $outer;
            private final Map sizeMap$1;
            private final BlockManagerId address$1;
            private final HashSet remainingBlocks$1;

            public void onBlockTransferSuccess(String x$1, ManagedBuffer x$2) {
                super.onBlockTransferSuccess(x$1, x$2);
            }

            public void onBlockTransferFailure(String x$1, Throwable x$2) {
                super.onBlockTransferFailure(x$1, x$2);
            }

            public String getTransferType() {
                return super.getTransferType();
            }

            public void handleResult(PushResult result) {
                this.$outer.submitTask(() -> {
                    if ($this.$outer.org$apache$spark$shuffle$ShuffleBlockPusher$$updateStateAndCheckIfPushMore(BoxesRunTime.unboxToInt((Object)$this.sizeMap$1.apply((Object)result.blockId())), $this.address$1, (HashSet<String>)$this.remainingBlocks$1, result)) {
                        $this.$outer.tryPushUpToMax();
                        return;
                    }
                });
            }

            public void onBlockPushSuccess(String blockId, ManagedBuffer data) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Push for block ").append(blockId).append(" to ").append($this.address$1).append(" successful.").toString());
                this.handleResult(new PushResult(blockId, null));
            }

            public void onBlockPushFailure(String blockId, Throwable exception) {
                if (!this.$outer.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler.shouldLogError(exception)) {
                    this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Pushing block ").append(blockId).append(" to ").append($this.address$1).append(" failed.").toString(), exception);
                } else {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Pushing block ").append(blockId).append(" to ").append($this.address$1).append(" failed.").toString(), exception);
                }
                this.handleResult(new PushResult(blockId, exception));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sizeMap$1 = sizeMap$1;
                this.address$1 = address$1;
                this.remainingBlocks$1 = remainingBlocks$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onBlockPushSuccess$1(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String ), $anonfun$onBlockPushFailure$1(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String ), $anonfun$onBlockPushFailure$2(org.apache.spark.shuffle.ShuffleBlockPusher$$anon$2 java.lang.String )}, serializedLambda);
            }
        };
        Tuple2 tuple2 = Utils$.MODULE$.randomize((TraversableOnce)blockIds.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.sliceReqBufferIntoBlockBuffers(request.reqBuffer(), (Seq<Object>)((Seq)request.blocks().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())))), Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(Tuple2.class)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq blockPushIds = (Seq)tuple2._1();
        Seq blockPushBuffers = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)blockPushIds, (Object)blockPushBuffers);
        Seq blockPushIds2 = (Seq)tuple22._1();
        Seq blockPushBuffers2 = (Seq)tuple22._2();
        SparkEnv$.MODULE$.get().blockManager().blockStoreClient().pushBlocks(address.host(), address.port(), (String[])blockPushIds2.toArray(ClassTag$.MODULE$.apply(String.class)), (ManagedBuffer[])blockPushBuffers2.toArray(ClassTag$.MODULE$.apply(ManagedBuffer.class)), blockPushListener);
    }

    private ManagedBuffer[] sliceReqBufferIntoBlockBuffers(ManagedBuffer reqBuffer, Seq<Object> blockSizes) {
        if (blockSizes.size() == 1) {
            return (ManagedBuffer[])((Object[])new ManagedBuffer[]{reqBuffer});
        }
        ByteBuffer inMemoryBuffer = reqBuffer.nioByteBuffer();
        int[] blockOffsets = new int[blockSizes.size()];
        IntRef offset = IntRef.create((int)0);
        blockSizes.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            blockOffsets$1[index] = offset$1.elem;
            offset$1.elem += BoxesRunTime.unboxToInt((Object)blockSizes.apply(index));
        });
        return (ManagedBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(blockOffsets)).zip(blockSizes, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int offset = tuple2._1$mcI$sp();
                int size = tuple2._2$mcI$sp();
                return new NioManagedBuffer(((ByteBuffer)inMemoryBuffer.duplicate().position(offset).limit(offset + size)).slice());
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NioManagedBuffer.class))))).toArray(ClassTag$.MODULE$.apply(ManagedBuffer.class));
    }

    public synchronized boolean org$apache$spark$shuffle$ShuffleBlockPusher$$updateStateAndCheckIfPushMore(long bytesPushed, BlockManagerId address, HashSet<String> remainingBlocks, PushResult pushResult) {
        remainingBlocks.$minus$eq((Object)pushResult.blockId());
        this.bytesInFlight_$eq(this.bytesInFlight() - bytesPushed);
        this.numBlocksInFlightPerAddress.update((Object)address, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.apply((Object)address)) - 1)));
        if (remainingBlocks.isEmpty()) {
            --this.reqsInFlight;
        }
        if (pushResult.failure() != null && pushResult.failure().getCause() instanceof ConnectException && !this.unreachableBlockMgrs().contains((Object)address)) {
            IntRef removed = IntRef.create((int)0);
            this.unreachableBlockMgrs().add((Object)address);
            removed.elem += this.pushRequests.dequeueAll((Function1 & Serializable & scala.Serializable)req -> BoxesRunTime.boxToBoolean((boolean)ShuffleBlockPusher.$anonfun$updateStateAndCheckIfPushMore$1(address, req))).length();
            removed.elem += BoxesRunTime.unboxToInt((Object)this.deferredPushRequests.remove((Object)address).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.length())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Received a ConnectException from ").append(address).append(". ").append("Dropping ").append(removed$1.elem).append(" push-requests and ").append("not pushing any more blocks to this address.").toString());
        }
        if (pushResult.failure() != null && !this.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler.shouldRetryError(pushResult.failure())) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Encountered an exception from ").append(address).append(" which indicates that push needs to ").append("stop.").toString());
            return false;
        }
        if (this.reqsInFlight <= 0 && this.pushRequests.isEmpty() && this.deferredPushRequests.isEmpty()) {
            this.notifyDriverAboutPushCompletion();
        }
        return remainingBlocks.isEmpty() && (this.pushRequests.nonEmpty() || this.deferredPushRequests.nonEmpty());
    }

    /*
     * Unable to fully structure code
     */
    public void notifyDriverAboutPushCompletion() {
        block6: {
            Predef$.MODULE$.assert(this.shuffleId >= 0 && this.mapIndex >= 0);
            if (this.pushCompletionNotified) break block6;
            var2_1 = false;
            var3_2 = null;
            var4_3 = SparkEnv$.MODULE$.get().executorBackend();
            if (!(var4_3 instanceof Some)) ** GOTO lbl-1000
            var2_1 = true;
            var3_2 = (Some)var4_3;
            cb = (ExecutorBackend)var3_2.value();
            if (cb instanceof CoarseGrainedExecutorBackend) {
                var6_5 = (CoarseGrainedExecutorBackend)cb;
                var6_5.notifyDriverAboutPushCompletion(this.shuffleId, this.shuffleMergeId, this.mapIndex);
            } else if (var2_1 && (eb = (ExecutorBackend)var3_2.value()) != null) {
                var8_7 = eb;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$notifyDriverAboutPushCompletion$1(org.apache.spark.executor.ExecutorBackend ), ()Ljava/lang/String;)((ExecutorBackend)var8_7));
            } else if (None$.MODULE$.equals(var4_3)) {
            } else {
                throw new MatchError(var4_3);
            }
            this.pushCompletionNotified = true;
            return;
        }
    }

    public Seq<PushRequest> prepareBlockPushRequests(int numPartitions, int partitionId, int shuffleId, int shuffleMergeId, File dataFile, long[] partitionLengths, Seq<BlockManagerId> mergerLocs, TransportConf transportConf) {
        LongRef offset = LongRef.create((long)0L);
        IntRef currentReqSize = IntRef.create((int)0);
        LongRef currentReqOffset = LongRef.create((long)0L);
        IntRef currentMergerId = IntRef.create((int)0);
        int numMergers = mergerLocs.length();
        ArrayBuffer requests = new ArrayBuffer();
        ObjectRef blocks = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)reduceId -> {
            long blockSize = partitionLengths[reduceId];
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Block ").append(new ShufflePushBlockId(shuffleId, shuffleMergeId, partitionId, reduceId)).append(" is of size ").append(blockSize).toString());
            if (blockSize > 0L) {
                int mergerId = (int)package$.MODULE$.min(package$.MODULE$.floor((double)reduceId * 1.0 / (double)numPartitions * (double)numMergers), (double)(numMergers - 1));
                if ((long)currentReqSize$1.elem + blockSize <= $this.maxBlockBatchSize && ((ArrayBuffer)blocks$1.elem).size() < $this.maxBlocksInFlightPerAddress && mergerId == currentMergerId$1.elem && blockSize <= $this.maxBlockSizeToPush) {
                    currentReqSize$1.elem += (int)blockSize;
                } else {
                    if (((ArrayBuffer)blocks$1.elem).nonEmpty()) {
                        requests.$plus$eq((Object)new PushRequest((BlockManagerId)mergerLocs.apply(currentMergerId$1.elem), (Seq<Tuple2<BlockId, Object>>)((ArrayBuffer)blocks$1.elem).toSeq(), this.createRequestBuffer(transportConf, dataFile, currentReqOffset$1.elem, currentReqSize$1.elem)));
                        blocks$1.elem = new ArrayBuffer();
                    }
                    currentReqSize$1.elem = 0;
                    currentReqOffset$1.elem = -1L;
                    currentMergerId$1.elem = mergerId;
                }
                if (blockSize <= $this.maxBlockSizeToPush) {
                    int blockSizeInt = (int)blockSize;
                    ((ArrayBuffer)blocks$1.elem).$plus$eq((Object)new Tuple2((Object)new ShufflePushBlockId(shuffleId, shuffleMergeId, partitionId, reduceId), (Object)BoxesRunTime.boxToInteger((int)blockSizeInt)));
                    if (currentReqOffset$1.elem == -1L) {
                        currentReqOffset$1.elem = offset$2.elem;
                    }
                    if (currentReqSize$1.elem == 0) {
                        currentReqSize$1.elem += blockSizeInt;
                    }
                }
            }
            offset$2.elem += blockSize;
        });
        Object object = ((ArrayBuffer)blocks.elem).nonEmpty() ? requests.$plus$eq((Object)new PushRequest((BlockManagerId)mergerLocs.apply(currentMergerId.elem), (Seq<Tuple2<BlockId, Object>>)((ArrayBuffer)blocks.elem).toSeq(), this.createRequestBuffer(transportConf, dataFile, currentReqOffset.elem, currentReqSize.elem))) : BoxedUnit.UNIT;
        return requests.toSeq();
    }

    public ManagedBuffer createRequestBuffer(TransportConf conf, File dataFile, long offset, long length) {
        return new FileSegmentManagedBuffer(conf, dataFile, offset, length);
    }

    public static final /* synthetic */ boolean $anonfun$pushUpToMax$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$pushUpToMax$2(ShuffleBlockPusher $this, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            BlockManagerId remoteAddress = (BlockManagerId)tuple2._1();
            Queue defReqQueue = (Queue)tuple2._2();
            while ($this.isRemoteBlockPushable$1(defReqQueue) && !$this.isRemoteAddressMaxedOut$1(remoteAddress, (PushRequest)defReqQueue.front())) {
                PushRequest request = (PushRequest)defReqQueue.dequeue();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Processing deferred push request for ").append(remoteAddress).append(" with ").append(request.blocks().length()).append(" blocks").toString());
                $this.sendRequest(request);
                Object object = defReqQueue.isEmpty() ? $this.deferredPushRequests.$minus$eq((Object)remoteAddress) : BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isRemoteBlockPushable$1(Queue pushReqQueue) {
        return pushReqQueue.nonEmpty() && (this.bytesInFlight() == 0L || this.reqsInFlight + 1 <= this.maxReqsInFlight && this.bytesInFlight() + (long)((PushRequest)pushReqQueue.front()).size() <= this.maxBytesInFlight);
    }

    private final boolean isRemoteAddressMaxedOut$1(BlockManagerId remoteAddress, PushRequest request) {
        return BoxesRunTime.unboxToInt((Object)this.numBlocksInFlightPerAddress.getOrElse((Object)remoteAddress, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + request.blocks().size() > this.maxBlocksInFlightPerAddress;
    }

    public static final /* synthetic */ boolean $anonfun$updateStateAndCheckIfPushMore$1(BlockManagerId address$2, PushRequest req) {
        BlockManagerId blockManagerId = req.address();
        BlockManagerId blockManagerId2 = address$2;
        return !(blockManagerId != null ? !((Object)blockManagerId).equals(blockManagerId2) : blockManagerId2 != null);
    }

    public static final /* synthetic */ String $anonfun$notifyDriverAboutPushCompletion$1(ExecutorBackend x5$1) {
        return new StringBuilder(45).append("Currently ").append(x5$1).append(" doesn't support push-based shuffle").toString();
    }

    public ShuffleBlockPusher(SparkConf conf) {
        this.conf = conf;
        Logging.$init$(this);
        this.maxBlockSizeToPush = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MAX_BLOCK_SIZE_TO_PUSH()));
        this.maxBlockBatchSize = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_MAX_BLOCK_BATCH_SIZE_FOR_PUSH()));
        this.maxBytesInFlight = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.REDUCER_MAX_SIZE_IN_FLIGHT())) * 1024L * 1024L;
        this.maxReqsInFlight = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.REDUCER_MAX_REQS_IN_FLIGHT()));
        this.maxBlocksInFlightPerAddress = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.REDUCER_MAX_BLOCKS_IN_FLIGHT_PER_ADDRESS()));
        this.bytesInFlight = 0L;
        this.reqsInFlight = 0;
        this.numBlocksInFlightPerAddress = new HashMap();
        this.deferredPushRequests = new HashMap();
        this.pushRequests = new Queue();
        this.org$apache$spark$shuffle$ShuffleBlockPusher$$errorHandler = this.createErrorHandler();
        this.unreachableBlockMgrs = new HashSet();
        this.shuffleId = -1;
        this.mapIndex = -1;
        this.shuffleMergeId = -1;
        this.pushCompletionNotified = false;
    }

    public static class PushRequest
    implements Product,
    scala.Serializable {
        private final BlockManagerId address;
        private final Seq<Tuple2<BlockId, Object>> blocks;
        private final ManagedBuffer reqBuffer;
        private final int size;

        public BlockManagerId address() {
            return this.address;
        }

        public Seq<Tuple2<BlockId, Object>> blocks() {
            return this.blocks;
        }

        public ManagedBuffer reqBuffer() {
            return this.reqBuffer;
        }

        public int size() {
            return this.size;
        }

        public PushRequest copy(BlockManagerId address, Seq<Tuple2<BlockId, Object>> blocks, ManagedBuffer reqBuffer) {
            return new PushRequest(address, blocks, reqBuffer);
        }

        public BlockManagerId copy$default$1() {
            return this.address();
        }

        public Seq<Tuple2<BlockId, Object>> copy$default$2() {
            return this.blocks();
        }

        public ManagedBuffer copy$default$3() {
            return this.reqBuffer();
        }

        public String productPrefix() {
            return "PushRequest";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.address();
                }
                case 1: {
                    return this.blocks();
                }
                case 2: {
                    return this.reqBuffer();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PushRequest;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PushRequest)) return false;
            boolean bl = true;
            if (!bl) return false;
            PushRequest pushRequest = (PushRequest)x$1;
            BlockManagerId blockManagerId = this.address();
            BlockManagerId blockManagerId2 = pushRequest.address();
            if (blockManagerId == null) {
                if (blockManagerId2 != null) {
                    return false;
                }
            } else if (!((Object)blockManagerId).equals(blockManagerId2)) return false;
            Seq<Tuple2<BlockId, Object>> seq = this.blocks();
            Seq<Tuple2<BlockId, Object>> seq2 = pushRequest.blocks();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            ManagedBuffer managedBuffer = this.reqBuffer();
            ManagedBuffer managedBuffer2 = pushRequest.reqBuffer();
            if (managedBuffer == null) {
                if (managedBuffer2 != null) {
                    return false;
                }
            } else if (!managedBuffer.equals(managedBuffer2)) return false;
            if (!pushRequest.canEqual(this)) return false;
            return true;
        }

        public PushRequest(BlockManagerId address, Seq<Tuple2<BlockId, Object>> blocks, ManagedBuffer reqBuffer) {
            this.address = address;
            this.blocks = blocks;
            this.reqBuffer = reqBuffer;
            Product.$init$((Product)this);
            this.size = BoxesRunTime.unboxToInt((Object)((TraversableOnce)blocks.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
    }

    private static class PushResult
    implements Product,
    scala.Serializable {
        private final String blockId;
        private final Throwable failure;

        public String blockId() {
            return this.blockId;
        }

        public Throwable failure() {
            return this.failure;
        }

        public PushResult copy(String blockId, Throwable failure) {
            return new PushResult(blockId, failure);
        }

        public String copy$default$1() {
            return this.blockId();
        }

        public Throwable copy$default$2() {
            return this.failure();
        }

        public String productPrefix() {
            return "PushResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.blockId();
                }
                case 1: {
                    return this.failure();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PushResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PushResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            PushResult pushResult = (PushResult)x$1;
            String string = this.blockId();
            String string2 = pushResult.blockId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.failure();
            Throwable throwable2 = pushResult.failure();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!pushResult.canEqual(this)) return false;
            return true;
        }

        public PushResult(String blockId, Throwable failure) {
            this.blockId = blockId;
            this.failure = failure;
            Product.$init$((Product)this);
        }
    }
}

