/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestThrottleSettings {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThrottleSettings.class);

    @Test
    public void testMerge() throws IOException {
        QuotaProtos.TimedQuota tq1 = QuotaProtos.TimedQuota.newBuilder().setSoftLimit(10L).setScope(QuotaProtos.QuotaScope.MACHINE).setTimeUnit(HBaseProtos.TimeUnit.MINUTES).build();
        QuotaProtos.ThrottleRequest tr1 = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(tq1).setType(QuotaProtos.ThrottleType.REQUEST_NUMBER).build();
        ThrottleSettings orig = new ThrottleSettings("joe", null, null, null, tr1);
        QuotaProtos.TimedQuota tq2 = QuotaProtos.TimedQuota.newBuilder().setSoftLimit(10L).setScope(QuotaProtos.QuotaScope.MACHINE).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build();
        QuotaProtos.ThrottleRequest tr2 = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(tq2).setType(QuotaProtos.ThrottleType.REQUEST_NUMBER).build();
        ThrottleSettings merged = orig.merge((QuotaSettings)new ThrottleSettings("joe", null, null, null, tr2));
        Assert.assertEquals((long)10L, (long)merged.getSoftLimit());
        Assert.assertEquals((Object)ThrottleType.REQUEST_NUMBER, (Object)merged.getThrottleType());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)merged.getTimeUnit()));
    }

    @Test
    public void testIncompatibleThrottleTypes() throws IOException {
        QuotaProtos.TimedQuota requestsQuota = QuotaProtos.TimedQuota.newBuilder().setSoftLimit(10L).setScope(QuotaProtos.QuotaScope.MACHINE).setTimeUnit(HBaseProtos.TimeUnit.MINUTES).build();
        QuotaProtos.ThrottleRequest requestsQuotaReq = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(requestsQuota).setType(QuotaProtos.ThrottleType.REQUEST_NUMBER).build();
        ThrottleSettings orig = new ThrottleSettings("joe", null, null, null, requestsQuotaReq);
        QuotaProtos.TimedQuota readsQuota = QuotaProtos.TimedQuota.newBuilder().setSoftLimit(10L).setScope(QuotaProtos.QuotaScope.MACHINE).setTimeUnit(HBaseProtos.TimeUnit.SECONDS).build();
        QuotaProtos.ThrottleRequest readsQuotaReq = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(readsQuota).setType(QuotaProtos.ThrottleType.READ_NUMBER).build();
        try {
            orig.merge((QuotaSettings)new ThrottleSettings("joe", null, null, null, readsQuotaReq));
            Assert.fail((String)"A read throttle should not be capable of being merged with a request quota");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoThrottleReturnsOriginal() throws IOException {
        QuotaProtos.ThrottleRequest tr2;
        QuotaProtos.TimedQuota tq1 = QuotaProtos.TimedQuota.newBuilder().setSoftLimit(10L).setScope(QuotaProtos.QuotaScope.MACHINE).setTimeUnit(HBaseProtos.TimeUnit.MINUTES).build();
        QuotaProtos.ThrottleRequest tr1 = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(tq1).setType(QuotaProtos.ThrottleType.REQUEST_NUMBER).build();
        ThrottleSettings orig = new ThrottleSettings("joe", null, null, null, tr1);
        Assert.assertTrue((String)"The same object should be returned by merge, but it wasn't", (orig == orig.merge((QuotaSettings)new ThrottleSettings("joe", null, null, null, tr2 = QuotaProtos.ThrottleRequest.newBuilder().setType(QuotaProtos.ThrottleType.REQUEST_NUMBER).build())) ? 1 : 0) != 0);
    }
}

