/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.util.List;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POBroadcastSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;

public class BroadcastConverter
implements RDDConverter<Tuple, Tuple, POBroadcastSpark> {
    private final JavaSparkContext sc;

    public BroadcastConverter(JavaSparkContext sc) {
        this.sc = sc;
    }

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POBroadcastSpark po) {
        SparkUtil.assertPredecessorSize(predecessors, po, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        JavaRDD javaRDD = new JavaRDD(rdd, SparkUtil.getManifest(Tuple.class));
        Broadcast broadcastedRDD = this.sc.broadcast((Object)javaRDD.collect());
        SparkPigContext.get();
        SparkPigContext.getBroadcastedVars().put(po.getBroadcastedVariableName(), (Broadcast<List<Tuple>>)broadcastedRDD);
        return rdd;
    }
}

