/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.Serializable;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.data.Tuple;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.runtime.AbstractFunction1;

public class FilterConverter
implements RDDConverter<Tuple, Tuple, POFilter> {
    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POFilter physicalOperator) {
        SparkUtil.assertPredecessorSize(predecessors, physicalOperator, 1);
        RDD<Tuple> rdd = predecessors.get(0);
        FilterFunction filterFunction = new FilterFunction(physicalOperator);
        return rdd.filter((Function1)filterFunction);
    }

    private static class FilterFunction
    extends AbstractFunction1<Tuple, Object>
    implements Serializable {
        private POFilter poFilter;

        private FilterFunction(POFilter poFilter) {
            this.poFilter = poFilter;
        }

        public Boolean apply(Tuple v1) {
            Result result;
            try {
                this.poFilter.setInputs(null);
                this.poFilter.attachInput(v1);
                result = this.poFilter.getNextTuple();
            }
            catch (ExecException e) {
                throw new RuntimeException("Couldn't filter tuple", e);
            }
            if (result == null) {
                return false;
            }
            switch (result.returnStatus) {
                case 0: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
            throw new RuntimeException("Unexpected response code from filter: " + result);
        }
    }
}

