/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.HExecutionEngine;
import org.apache.pig.backend.hadoop.executionengine.tez.TezLauncher;
import org.apache.pig.impl.PigContext;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.tez.TezPigScriptStats;
import org.apache.pig.tools.pigstats.tez.TezScriptState;

public class TezExecutionEngine
extends HExecutionEngine {
    public TezExecutionEngine(PigContext pigContext) {
        super(pigContext);
        this.launcher = new TezLauncher();
    }

    @Override
    public ScriptState instantiateScriptState() {
        TezScriptState ss = new TezScriptState(UUID.randomUUID().toString());
        ss.setPigContext(this.pigContext);
        return ss;
    }

    @Override
    public PigStats instantiatePigStats() {
        return new TezPigScriptStats(this.pigContext);
    }

    @Override
    public JobConf getExecConf(Properties properties) throws ExecException {
        JobConf jc = super.getExecConf(properties);
        jc.addResource("tez-site.xml");
        return jc;
    }
}

