/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.LoadCaster;
import org.apache.pig.PigStreamingBase;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.WritableByteArray;
import org.apache.pig.impl.util.StorageUtil;

public class PigStreaming
extends PigStreamingBase {
    private byte recordDel = (byte)10;
    private byte fieldDel = (byte)9;
    private WritableByteArray out = new WritableByteArray();

    public PigStreaming() {
    }

    public PigStreaming(String delimiter) {
        this();
        this.fieldDel = StorageUtil.parseFieldDel(delimiter);
    }

    @Override
    public WritableByteArray serializeToBytes(Tuple t) throws IOException {
        this.out.reset();
        int sz = t.size();
        for (int i = 0; i < sz; ++i) {
            Object field = t.get(i);
            StorageUtil.putField(this.out, field);
            if (i == sz - 1) {
                this.out.write(this.recordDel);
                continue;
            }
            this.out.write(this.fieldDel);
        }
        return this.out;
    }

    @Override
    public Tuple deserialize(byte[] bytes, int offset, int length) throws IOException {
        return StorageUtil.bytesToTuple(bytes, offset, length, this.fieldDel);
    }

    @Override
    public LoadCaster getLoadCaster() throws IOException {
        return new Utf8StorageConverter();
    }
}

