/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.data.AppendableSchemaTuple;
import org.apache.pig.data.SchemaTuple;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.SchemaTupleClassGenerator;
import org.apache.pig.data.TupleMaker;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SchemaTupleFactory
implements TupleMaker<SchemaTuple<?>> {
    static final Log LOG = LogFactory.getLog(SchemaTupleFactory.class);
    private SchemaTuple.SchemaTupleQuickGenerator<? extends SchemaTuple<?>> generator;
    private Class<SchemaTuple<?>> clazz;
    private int tupleSize;

    protected SchemaTupleFactory(Class<SchemaTuple<?>> clazz, SchemaTuple.SchemaTupleQuickGenerator<? extends SchemaTuple<?>> generator) {
        this.clazz = clazz;
        this.generator = generator;
        this.tupleSize = generator.make().size();
    }

    public static boolean isGeneratable(Schema s) {
        if (s == null || s.size() == 0) {
            return false;
        }
        for (Schema.FieldSchema fs : s.getFields()) {
            if (fs.type != 110 || SchemaTupleFactory.isGeneratable(fs.schema)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SchemaTuple<?> newTuple() {
        return this.generator.make();
    }

    @Override
    public SchemaTuple<?> newTuple(int size) {
        if (size != this.tupleSize) {
            throw new RuntimeException("Request a SchemaTuple of the wrong size! Requested [" + size + "], can only be [" + this.tupleSize + "]");
        }
        return this.generator.make();
    }

    public Class<SchemaTuple<?>> tupleClass() {
        return this.clazz;
    }

    public boolean isFixedSize() {
        return this.clazz.isAssignableFrom(AppendableSchemaTuple.class);
    }

    protected static SchemaTupleFactory getInstance(int id) {
        return SchemaTupleBackend.newSchemaTupleFactory(id);
    }

    public static SchemaTupleFactory getInstance(Schema s, boolean isAppendable, SchemaTupleClassGenerator.GenContext context) {
        return SchemaTupleBackend.newSchemaTupleFactory(s, isAppendable, context);
    }

    public static SchemaTupleFactory getInstance(Schema s, boolean isAppendable) {
        return SchemaTupleFactory.getInstance(s, isAppendable, SchemaTupleClassGenerator.GenContext.FORCE_LOAD);
    }

    public static SchemaTupleFactory getInstance(Schema s) {
        return SchemaTupleFactory.getInstance(s, false);
    }
}

