/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class NodeIdGenerator {
    private ThreadLocal<Map<String, AtomicLong>> scopeToIdMap = new ThreadLocal<Map<String, AtomicLong>>(){

        @Override
        protected Map<String, AtomicLong> initialValue() {
            return new HashMap<String, AtomicLong>();
        }
    };
    private static final NodeIdGenerator theGenerator = new NodeIdGenerator();

    private NodeIdGenerator() {
    }

    public static NodeIdGenerator getGenerator() {
        return theGenerator;
    }

    public long getNextNodeId(String scope) {
        Map<String, AtomicLong> map = this.scopeToIdMap.get();
        AtomicLong l = map.get(scope);
        if (l == null) {
            l = new AtomicLong();
            map.put(scope, l);
        }
        return l.getAndIncrement();
    }

    @VisibleForTesting
    public static void reset(String scope) {
        NodeIdGenerator.theGenerator.scopeToIdMap.get().remove(scope);
    }

    @VisibleForTesting
    public static void reset() {
        NodeIdGenerator.theGenerator.scopeToIdMap.remove();
    }
}

