/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.util.MultiMap;

public class PlanDumper<E extends Operator, P extends OperatorPlan<E>, S extends OperatorPlan<? extends Operator>> {
    protected PrintStream ps;
    protected P plan;
    protected boolean isVerbose = true;

    public PlanDumper(P plan, PrintStream ps) {
        this.plan = plan;
        this.ps = ps;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public void dump() {
        for (Operator op : this.plan) {
            MultiMap<Operator, S> map = this.getMultiInputNestedPlans(op);
            if (this.isVerbose && !map.isEmpty()) {
                this.dumpMultiInputNestedOperator(op, map);
                continue;
            }
            Collection<S> plans = this.getMultiOutputNestedPlans(op);
            if (plans.size() > 0) {
                this.dumpMultiOutputNestedOperator(op, plans);
                continue;
            }
            plans = this.getNestedPlans(op);
            if (this.isVerbose && plans.size() > 0) {
                this.dumpNestedOperator(op, plans);
                continue;
            }
            this.dumpOperator(op);
        }
        for (Operator op : this.plan) {
            List<Operator> successors = ((OperatorPlan)this.plan).getSuccessors((Operator)op);
            if (successors == null) continue;
            for (Operator suc : successors) {
                this.dumpEdge(op, suc);
            }
        }
    }

    protected PlanDumper makeDumper(S plan, PrintStream ps) {
        return new PlanDumper<E, S, S>(plan, ps);
    }

    protected void dumpOperator(E op) {
        this.ps.println(((Operator)op).name().replace(" ", "_"));
    }

    protected void dumpMultiInputNestedOperator(E op, MultiMap<E, S> plans) {
        this.dumpOperator(op);
        for (Operator aop : plans.keySet()) {
            for (OperatorPlan plan : plans.get(aop)) {
                PlanDumper dumper = this.makeDumper(plan, this.ps);
                dumper.dump();
            }
        }
    }

    protected void dumpMultiOutputNestedOperator(E op, Collection<S> plans) {
        this.dumpOperator(op);
        for (OperatorPlan plan : plans) {
            PlanDumper dumper = this.makeDumper(plan, this.ps);
            dumper.dump();
            for (Operator p : plan.getRoots()) {
                this.dumpEdge((Operator)op, p);
            }
        }
    }

    protected void dumpNestedOperator(E op, Collection<S> plans) {
        this.dumpOperator(op);
        for (OperatorPlan plan : plans) {
            PlanDumper dumper = this.makeDumper(plan, this.ps);
            dumper.dump();
        }
    }

    protected void dumpEdge(Operator op, Operator suc) {
        this.ps.println(op.name() + " -> " + suc.name());
    }

    protected MultiMap<E, S> getMultiInputNestedPlans(E op) {
        return new MultiMap();
    }

    protected Collection<S> getMultiOutputNestedPlans(E op) {
        return new LinkedList();
    }

    protected Collection<S> getNestedPlans(E op) {
        return new LinkedList();
    }

    protected void join(String sep, String[] strings) {
        if (strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                this.ps.print(sep);
            }
            this.ps.print(strings[i]);
        }
    }
}

