/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanPrinter;

public class LogicalExpressionPlan
extends BaseOperatorPlan {
    @Override
    public boolean isEqual(OperatorPlan other) throws FrontendException {
        if (other != null && other instanceof LogicalExpressionPlan) {
            LogicalExpressionPlan otherPlan = (LogicalExpressionPlan)other;
            List<Operator> roots = this.getSources();
            List<Operator> otherRoots = otherPlan.getSources();
            if (roots.size() == 0 && otherRoots.size() == 0) {
                return true;
            }
            if (roots.size() > 1 || otherRoots.size() > 1) {
                throw new FrontendException("Found LogicalExpressionPlan with more than one root.  Unexpected.", 2224);
            }
            return roots.get(0).isEqual(otherRoots.get(0));
        }
        return false;
    }

    @Override
    public void explain(PrintStream ps, String format, boolean verbose) throws FrontendException {
        ps.println("#-----------------------------------------------");
        ps.println("# New Logical Expression Plan:");
        ps.println("#-----------------------------------------------");
        LogicalPlanPrinter npp = new LogicalPlanPrinter((OperatorPlan)this, ps);
        npp.visit();
    }

    public List<Operator> merge(LogicalExpressionPlan lgExpPlan) {
        List<Operator> sources = lgExpPlan.getSources();
        Iterator<Operator> iter = lgExpPlan.getOperators();
        while (iter.hasNext()) {
            LogicalExpression op = (LogicalExpression)iter.next();
            op.setPlan(this);
            this.add(op);
        }
        iter = lgExpPlan.getOperators();
        while (iter.hasNext()) {
            LogicalExpression startOp = (LogicalExpression)iter.next();
            ArrayList endOps = (ArrayList)lgExpPlan.fromEdges.get(startOp);
            if (endOps == null) continue;
            for (Operator endOp : endOps) {
                this.connect(startOp, endOp);
            }
        }
        return sources;
    }

    public LogicalExpressionPlan deepCopy() throws FrontendException {
        LogicalExpressionPlan result = new LogicalExpressionPlan();
        LogicalExpression root = (LogicalExpression)this.getSources().get(0);
        LogicalExpression newRoot = root.deepCopy(result);
        result.add(newRoot);
        return result;
    }
}

