/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import org.apache.pig.data.DataByteArray;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"DataByteArray"})
public class RubyDataByteArray
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyDataByteArray(runtime, klass);
        }
    };
    private DataByteArray internalDBA;

    public static RubyClass define(Ruby runtime) {
        RubyClass result = runtime.defineClass("DataByteArray", runtime.getObject(), ALLOCATOR);
        result.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyDataByteArray;
            }
        };
        result.defineAnnotatedMethods(RubyDataByteArray.class);
        return result;
    }

    protected RubyDataByteArray(Ruby ruby, RubyClass rc) {
        super(ruby, rc);
        this.internalDBA = new DataByteArray();
    }

    protected RubyDataByteArray(Ruby ruby, RubyClass rc, DataByteArray dba) {
        this(ruby, rc);
        byte[] buf1 = dba.get();
        byte[] buf2 = new byte[buf1.length];
        System.arraycopy(buf1, 0, buf2, 0, buf1.length);
        this.internalDBA = new DataByteArray(buf2);
    }

    protected RubyDataByteArray(Ruby ruby, RubyClass rc, DataByteArray dba1, DataByteArray dba2) {
        super(ruby, rc);
        this.internalDBA = new DataByteArray(dba1, dba2);
    }

    protected RubyDataByteArray(Ruby ruby, RubyClass rc, byte[] buf) {
        super(ruby, rc);
        this.internalDBA = new DataByteArray(buf);
    }

    public DataByteArray getDBA() {
        return this.internalDBA;
    }

    @JRubyMethod
    public RubyDataByteArray initialize() {
        this.internalDBA = new DataByteArray();
        return this;
    }

    @JRubyMethod
    public RubyDataByteArray initialize(IRubyObject arg) {
        if (arg instanceof RubyString) {
            this.internalDBA.set(arg.toString());
        } else if (arg instanceof RubyDataByteArray) {
            byte[] buf1 = ((RubyDataByteArray)arg).getDBA().get();
            byte[] buf2 = new byte[buf1.length];
            System.arraycopy(buf1, 0, buf2, 0, buf1.length);
            this.internalDBA = new DataByteArray(buf2);
        } else {
            this.internalDBA.set((byte[])arg.toJava(byte[].class));
        }
        return this;
    }

    @JRubyMethod
    public RubyDataByteArray initialize(IRubyObject arg1, IRubyObject arg2) {
        if (!(arg1 instanceof RubyDataByteArray) || !(arg2 instanceof RubyDataByteArray)) {
            throw new IllegalArgumentException("Invalid arguments passed to DataByteArray");
        }
        this.internalDBA = new DataByteArray(((RubyDataByteArray)arg1).getDBA(), ((RubyDataByteArray)arg2).getDBA());
        return this;
    }

    @JRubyMethod(name={"add!", "append"})
    public void append(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        RubyDataByteArray toAppend = new RubyDataByteArray(runtime, runtime.getClass("DataByteArray")).initialize(arg);
        this.internalDBA.append(toAppend.getDBA());
    }

    @JRubyMethod
    public static RubyFixnum compare(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
        byte[] buf1 = arg1 instanceof RubyDataByteArray ? ((RubyDataByteArray)arg1).getDBA().get() : (byte[])arg1.toJava(byte[].class);
        byte[] buf2 = arg2 instanceof RubyDataByteArray ? ((RubyDataByteArray)arg2).getDBA().get() : (byte[])arg2.toJava(byte[].class);
        return RubyFixnum.newFixnum((Ruby)context.getRuntime(), (long)DataByteArray.compare(buf1, buf2));
    }

    @JRubyMethod
    public RubyFixnum compareTo(ThreadContext context, IRubyObject arg) {
        int compResult = arg instanceof RubyDataByteArray ? this.internalDBA.compareTo(((RubyDataByteArray)arg).getDBA()) : this.internalDBA.compareTo(new DataByteArray((byte[])arg.toJava(byte[].class)));
        return RubyFixnum.newFixnum((Ruby)context.getRuntime(), (long)compResult);
    }

    @JRubyMethod(name={"eql?", "=="})
    public RubyBoolean equals(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        if (arg instanceof RubyDataByteArray) {
            return RubyBoolean.newBoolean((Ruby)runtime, (boolean)this.internalDBA.equals(((RubyDataByteArray)arg).getDBA()));
        }
        return runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject hash(ThreadContext context) {
        return RubyFixnum.newFixnum((Ruby)context.getRuntime(), (long)this.internalDBA.hashCode());
    }

    @JRubyMethod
    public void set(IRubyObject arg) {
        if (arg instanceof RubyDataByteArray) {
            this.internalDBA = ((RubyDataByteArray)arg).getDBA();
        } else if (arg instanceof RubyString) {
            this.internalDBA.set(arg.toString());
        } else {
            this.internalDBA.set((byte[])arg.toJava(byte[].class));
        }
    }

    @JRubyMethod(name={"size", "length"})
    public RubyFixnum size(ThreadContext context) {
        return RubyFixnum.newFixnum((Ruby)context.getRuntime(), (long)this.internalDBA.size());
    }

    @JRubyMethod(name={"+"})
    public IRubyObject plus(ThreadContext context, IRubyObject arg) {
        Ruby runtime = context.getRuntime();
        RubyDataByteArray toAdd = new RubyDataByteArray(runtime, runtime.getClass("DataByteArray")).initialize(arg);
        return new RubyDataByteArray(runtime, runtime.getClass("DataByteArray"), this.internalDBA, toAdd.getDBA());
    }

    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject toString(ThreadContext context) {
        return RubyString.newString((Ruby)context.getRuntime(), (String)this.internalDBA.toString());
    }
}

