/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.tez;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigProgressNotificationListener;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.tez.PigTezProgressNotificationListener;
import org.apache.pig.tools.pigstats.tez.TezDAGStats;
import org.apache.pig.tools.pigstats.tez.TezPigScriptStats;
import org.apache.pig.tools.pigstats.tez.TezVertexStats;

public class TezScriptState
extends ScriptState {
    private static final Log LOG = LogFactory.getLog(TezScriptState.class);
    private List<PigTezProgressNotificationListener> tezListeners = Lists.newArrayList();
    private Map<String, TezDAGScriptInfo> dagScriptInfo = Maps.newHashMap();

    public TezScriptState(String id) {
        super(id);
    }

    public static TezScriptState get() {
        return (TezScriptState)ScriptState.get();
    }

    @Override
    public void registerListener(PigProgressNotificationListener listener) {
        super.registerListener(listener);
        if (listener instanceof PigTezProgressNotificationListener) {
            this.tezListeners.add((PigTezProgressNotificationListener)listener);
        }
    }

    public void dagLaunchNotification(String dagName, OperatorPlan<?> dagPlan, int numVerticesToLaunch) {
        for (PigTezProgressNotificationListener listener : this.tezListeners) {
            listener.dagLaunchNotification(this.id, dagName, dagPlan, numVerticesToLaunch);
        }
    }

    public void dagStartedNotification(String dagName, String assignedApplicationId) {
        for (PigTezProgressNotificationListener listener : this.tezListeners) {
            listener.dagStartedNotification(this.id, dagName, assignedApplicationId);
        }
    }

    public void dagProgressNotification(String dagName, int numVerticesCompleted, int progress) {
        for (PigTezProgressNotificationListener listener : this.tezListeners) {
            listener.dagProgressNotification(this.id, dagName, numVerticesCompleted, progress);
        }
    }

    public void dagCompletedNotification(String dagName, TezDAGStats tezDAGStats) {
        for (PigTezProgressNotificationListener listener : this.tezListeners) {
            listener.dagCompletedNotification(this.id, dagName, tezDAGStats.isSuccessful(), tezDAGStats);
        }
    }

    public void addDAGSettingsToConf(Configuration conf) {
        LOG.info((Object)"Pig script settings are added to the job");
        conf.set(ScriptState.PIG_PROPERTY.HADOOP_VERSION.toString(), this.getHadoopVersion());
        conf.set(ScriptState.PIG_PROPERTY.VERSION.toString(), this.getPigVersion());
        conf.set(ScriptState.PIG_PROPERTY.SCRIPT_ID.toString(), this.id);
        conf.set(ScriptState.PIG_PROPERTY.SCRIPT.toString(), this.getSerializedScript());
        conf.set(ScriptState.PIG_PROPERTY.COMMAND_LINE.toString(), this.getCommandLine());
    }

    public void addVertexSettingsToConf(String dagName, TezOperator tezOp, Configuration conf) {
        try {
            LinkedList<POStore> stores = PlanHelper.getPhysicalOperators(tezOp.plan, POStore.class);
            ArrayList<String> outputDirs = new ArrayList<String>();
            for (POStore st : stores) {
                outputDirs.add(st.getSFile().getFileName());
            }
            conf.set(ScriptState.PIG_PROPERTY.MAP_OUTPUT_DIRS.toString(), LoadFunc.join(outputDirs, ","));
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get the map stores", (Throwable)e);
        }
        try {
            LinkedList<POLoad> lds = PlanHelper.getPhysicalOperators(tezOp.plan, POLoad.class);
            ArrayList<String> inputDirs = new ArrayList<String>();
            if (lds != null && lds.size() > 0) {
                for (POLoad ld : lds) {
                    inputDirs.add(ld.getLFile().getFileName());
                }
                conf.set(ScriptState.PIG_PROPERTY.INPUT_DIRS.toString(), LoadFunc.join(inputDirs, ","));
            }
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get the map loads", (Throwable)e);
        }
        this.setPigFeature(dagName, tezOp, conf);
        this.setJobParents(dagName, tezOp, conf);
        conf.set("mapreduce.workflow.id", "pig_" + this.id);
        conf.set("mapreduce.workflow.name", this.getFileName().isEmpty() ? "default" : this.getFileName());
        conf.set("mapreduce.workflow.node.name", tezOp.getOperatorKey().toString());
    }

    public void addWorkflowAdjacenciesToConf(TezOperPlan tezPlan, Configuration conf) {
        for (TezOperator source : tezPlan) {
            ArrayList<String> targets = new ArrayList<String>();
            if (tezPlan.getSuccessors(source) != null) {
                for (TezOperator target : tezPlan.getSuccessors(source)) {
                    targets.add(target.getOperatorKey().toString());
                }
            }
            String[] s = new String[targets.size()];
            conf.setStrings("mapreduce.workflow.adjacency." + source.getOperatorKey().toString(), targets.toArray(s));
        }
    }

    private void setPigFeature(String dagName, TezOperator tezOp, Configuration conf) {
        if (tezOp.isVertexGroup()) {
            return;
        }
        TezDAGScriptInfo dagInfo = this.getDAGScriptInfo(dagName);
        conf.set(ScriptState.PIG_PROPERTY.JOB_FEATURE.toString(), dagInfo.getPigFeatures(tezOp));
        if (this.scriptFeatures != 0L) {
            conf.set(ScriptState.PIG_PROPERTY.SCRIPT_FEATURES.toString(), String.valueOf(this.scriptFeatures));
        }
        conf.set(ScriptState.PIG_PROPERTY.JOB_ALIAS.toString(), dagInfo.getAlias(tezOp));
        conf.set(ScriptState.PIG_PROPERTY.JOB_ALIAS_LOCATION.toString(), dagInfo.getAliasLocation(tezOp));
    }

    private void setJobParents(String dagName, TezOperator tezOp, Configuration conf) {
        List<Operator> preds;
        if (tezOp.isVertexGroup()) {
            return;
        }
        TezVertexStats js = ((TezPigScriptStats)PigStats.get()).getVertexStats(dagName, tezOp.getOperatorKey().toString());
        if (js != null && (preds = js.getPlan().getPredecessors(js)) != null) {
            StringBuilder sb = new StringBuilder();
            for (Operator op : preds) {
                JobStats job = (JobStats)op;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(job.getJobId());
            }
            conf.set(ScriptState.PIG_PROPERTY.JOB_PARENTS.toString(), sb.toString());
        }
    }

    public TezDAGScriptInfo setDAGScriptInfo(TezPlanContainerNode tezPlanNode) {
        TezDAGScriptInfo info = new TezDAGScriptInfo(tezPlanNode.getTezOperPlan());
        this.dagScriptInfo.put(tezPlanNode.getOperatorKey().toString(), info);
        return info;
    }

    public TezDAGScriptInfo getDAGScriptInfo(String dagName) {
        return this.dagScriptInfo.get(dagName);
    }

    public static class TezDAGScriptInfo {
        private static final Log LOG = LogFactory.getLog(TezDAGScriptInfo.class);
        private TezOperPlan tezPlan;
        private String alias;
        private String aliasLocation;
        private String features;
        private Map<OperatorKey, String> featuresMap = Maps.newHashMap();
        private Map<OperatorKey, String> aliasMap = Maps.newHashMap();
        private Map<OperatorKey, String> aliasLocationMap = Maps.newHashMap();

        public TezDAGScriptInfo(TezOperPlan tezPlan) {
            this.tezPlan = tezPlan;
            this.initialize();
        }

        private void initialize() {
            try {
                new DAGAliasVisitor(this.tezPlan).visit();
            }
            catch (VisitorException e) {
                LOG.warn((Object)"Cannot calculate alias information for DAG", (Throwable)e);
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public String getAliasLocation() {
            return this.aliasLocation;
        }

        public String getPigFeatures() {
            return this.features;
        }

        public String getAlias(TezOperator tezOp) {
            return this.aliasMap.get(tezOp.getOperatorKey());
        }

        public String getAliasLocation(TezOperator tezOp) {
            return this.aliasLocationMap.get(tezOp.getOperatorKey());
        }

        public String getPigFeatures(TezOperator tezOp) {
            return this.featuresMap.get(tezOp.getOperatorKey());
        }

        class DAGAliasVisitor
        extends TezOpPlanVisitor {
            private Set<String> aliases;
            private Set<String> aliasLocations;
            private BitSet featureSet;

            public DAGAliasVisitor(TezOperPlan plan) {
                super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
                this.aliases = new HashSet<String>();
                this.aliasLocations = new HashSet<String>();
                this.featureSet = new BitSet();
            }

            @Override
            public void visitTezOp(TezOperator tezOp) throws VisitorException {
                if (tezOp.isVertexGroup()) {
                    this.featureSet.set(ScriptState.PIG_FEATURE.UNION.ordinal());
                    return;
                }
                ArrayList<String> aliasList = new ArrayList<String>();
                String aliasLocationStr = "";
                try {
                    ArrayList<String> aliasLocationList = new ArrayList<String>();
                    new ScriptState.AliasVisitor(tezOp.plan, aliasList, aliasLocationList).visit();
                    aliasLocationStr = aliasLocationStr + LoadFunc.join(aliasLocationList, ",");
                    if (!aliasList.isEmpty()) {
                        Collections.sort(aliasList);
                        this.aliases.addAll(aliasList);
                        this.aliasLocations.addAll(aliasLocationList);
                    }
                }
                catch (VisitorException e) {
                    LOG.warn((Object)"unable to get alias", (Throwable)e);
                }
                TezDAGScriptInfo.this.aliasMap.put(tezOp.getOperatorKey(), LoadFunc.join(aliasList, ","));
                TezDAGScriptInfo.this.aliasLocationMap.put(tezOp.getOperatorKey(), aliasLocationStr);
                BitSet feature = new BitSet();
                feature.clear();
                if (tezOp.isSkewedJoin()) {
                    feature.set(ScriptState.PIG_FEATURE.SKEWED_JOIN.ordinal());
                }
                if (tezOp.isGlobalSort()) {
                    feature.set(ScriptState.PIG_FEATURE.ORDER_BY.ordinal());
                }
                if (tezOp.isSampler()) {
                    feature.set(ScriptState.PIG_FEATURE.SAMPLER.ordinal());
                }
                if (tezOp.isIndexer()) {
                    feature.set(ScriptState.PIG_FEATURE.INDEXER.ordinal());
                }
                if (tezOp.isCogroup()) {
                    feature.set(ScriptState.PIG_FEATURE.COGROUP.ordinal());
                }
                if (tezOp.isGroupBy()) {
                    feature.set(ScriptState.PIG_FEATURE.GROUP_BY.ordinal());
                }
                if (tezOp.isRegularJoin()) {
                    feature.set(ScriptState.PIG_FEATURE.HASH_JOIN.ordinal());
                }
                if (tezOp.isBuildBloom()) {
                    feature.set(ScriptState.PIG_FEATURE.BUILD_BLOOM.ordinal());
                }
                if (tezOp.isFilterBloom()) {
                    feature.set(ScriptState.PIG_FEATURE.FILTER_BLOOM.ordinal());
                }
                if (tezOp.isUnion()) {
                    feature.set(ScriptState.PIG_FEATURE.UNION.ordinal());
                }
                if (tezOp.isNative()) {
                    feature.set(ScriptState.PIG_FEATURE.NATIVE.ordinal());
                }
                if (tezOp.isLimit() || tezOp.isLimitAfterSort()) {
                    feature.set(ScriptState.PIG_FEATURE.LIMIT.ordinal());
                }
                if (tezOp.isMergeJoin()) {
                    feature.set(ScriptState.PIG_FEATURE.MERGE_JOIN.ordinal());
                }
                if (tezOp.isMergeSparseJoin()) {
                    feature.set(ScriptState.PIG_FEATURE.MERGE_SPARSE_JOIN.ordinal());
                }
                if (tezOp.isMergeCogroup()) {
                    feature.set(ScriptState.PIG_FEATURE.MERGE_COGROUP.ordinal());
                }
                try {
                    new ScriptState.FeatureVisitor(tezOp.plan, feature).visit();
                }
                catch (VisitorException e) {
                    LOG.warn((Object)"Feature visitor failed", (Throwable)e);
                }
                StringBuilder sb = new StringBuilder();
                int i = feature.nextSetBit(0);
                while (i >= 0) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(ScriptState.PIG_FEATURE.values()[i].name());
                    i = feature.nextSetBit(i + 1);
                }
                TezDAGScriptInfo.this.featuresMap.put(tezOp.getOperatorKey(), sb.toString());
                for (i = 0; i < feature.length(); ++i) {
                    if (!feature.get(i)) continue;
                    this.featureSet.set(i);
                }
            }

            @Override
            public void visit() throws VisitorException {
                super.visit();
                if (!this.aliases.isEmpty()) {
                    ArrayList<String> aliasList = new ArrayList<String>(this.aliases);
                    ArrayList<String> aliasLocationList = new ArrayList<String>(this.aliasLocations);
                    Collections.sort(aliasList);
                    Collections.sort(aliasLocationList);
                    TezDAGScriptInfo.this.alias = LoadFunc.join(aliasList, ",");
                    TezDAGScriptInfo.this.aliasLocation = LoadFunc.join(aliasLocationList, ",");
                }
                StringBuilder sb = new StringBuilder();
                int i = this.featureSet.nextSetBit(0);
                while (i >= 0) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(ScriptState.PIG_FEATURE.values()[i].name());
                    i = this.featureSet.nextSetBit(i + 1);
                }
                TezDAGScriptInfo.this.features = sb.toString();
            }
        }
    }
}

