/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class Divide
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 1L;
    public static final short BIGDECIMAL_MINIMAL_SCALE = 6;
    private static final Log LOG = LogFactory.getLog(Divide.class);

    public Divide(OperatorKey k) {
        super(k);
    }

    public Divide(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitDivide(this);
    }

    @Override
    public String name() {
        return "Divide[" + DataType.findTypeName(this.resultType) + "] - " + this.mKey.toString();
    }

    protected Number divide(Number a, Number b, byte dataType) throws ExecException {
        switch (dataType) {
            case 25: {
                return (Double)a / (Double)b;
            }
            case 10: {
                return (Integer)a / (Integer)b;
            }
            case 15: {
                return (Long)a / (Long)b;
            }
            case 20: {
                return Float.valueOf(((Float)a).floatValue() / ((Float)b).floatValue());
            }
            case 65: {
                return ((BigInteger)a).divide((BigInteger)b);
            }
            case 70: {
                return this.bigDecimalDivideWithScale(a, b);
            }
        }
        throw new ExecException("called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    private Number bigDecimalDivideWithScale(Number a, Number b) {
        int resultScale = Math.max(6, ((BigDecimal)a).scale() + ((BigDecimal)b).precision() + 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("For bigdecimal divide: using " + resultScale + " as result scale."));
        }
        return ((BigDecimal)a).divide((BigDecimal)b, resultScale, RoundingMode.HALF_UP);
    }

    protected boolean equalsZero(Number a, byte dataType) throws ExecException {
        switch (dataType) {
            case 25: {
                return ((Double)a).equals(0.0);
            }
            case 10: {
                return ((Integer)a).equals(0);
            }
            case 15: {
                return ((Long)a).equals(0L);
            }
            case 20: {
                return ((Float)a).equals(Float.valueOf(0.0f));
            }
            case 65: {
                return BigInteger.ZERO.equals((BigInteger)a);
            }
            case 70: {
                return ((BigDecimal)a).signum() == 0;
            }
        }
        throw new ExecException("Called on unsupported Number class " + DataType.findTypeName(dataType));
    }

    protected Result genericGetNext(byte dataType) throws ExecException {
        Result r = this.accumChild(null, dataType);
        if (r != null) {
            return r;
        }
        Result res = this.lhs.getNext(dataType);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        Number left = (Number)res.result;
        res = this.rhs.getNext(dataType);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        Number right = (Number)res.result;
        if (this.equalsZero(right, dataType)) {
            if (pigLogger != null) {
                pigLogger.warn(this, "Divide by zero. Converting it to NULL.", PigWarning.DIVIDE_BY_ZERO);
            }
            res.result = null;
        } else {
            res.result = this.divide(left, right, dataType);
        }
        return res;
    }

    @Override
    public Result getNextDouble() throws ExecException {
        return this.genericGetNext((byte)25);
    }

    @Override
    public Result getNextFloat() throws ExecException {
        return this.genericGetNext((byte)20);
    }

    @Override
    public Result getNextInteger() throws ExecException {
        return this.genericGetNext((byte)10);
    }

    @Override
    public Result getNextLong() throws ExecException {
        return this.genericGetNext((byte)15);
    }

    @Override
    public Result getNextBigInteger() throws ExecException {
        return this.genericGetNext((byte)65);
    }

    @Override
    public Result getNextBigDecimal() throws ExecException {
        return this.genericGetNext((byte)70);
    }

    @Override
    public Divide clone() throws CloneNotSupportedException {
        Divide clone = new Divide(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

