/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduceCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultAbstractBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

public class POCounter
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    public static final Long ONE = 1L;
    private List<PhysicalPlan> counterPlans;
    private List<Boolean> mAscCols;
    private boolean isDenseRank = false;
    private boolean isRowNumber = false;
    private Long localCount = 1L;
    private Integer taskID = -1;
    private String operationID;

    public POCounter(OperatorKey k) {
        this(k, -1, null);
    }

    public POCounter(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POCounter(OperatorKey k, List<PhysicalOperator> inputs) {
        this(k, -1, inputs);
    }

    public POCounter(OperatorKey k, int rp, List<PhysicalOperator> inputs) {
        super(k, rp, inputs);
    }

    public POCounter(POCounter copy) {
        super(copy);
        this.counterPlans = copy.counterPlans;
        this.mAscCols = copy.mAscCols;
        this.isDenseRank = copy.isDenseRank;
        this.isRowNumber = copy.isRowNumber;
        this.operationID = copy.operationID;
    }

    public POCounter(OperatorKey operatorKey, int requestedParallelism, List inp, List<PhysicalPlan> counterPlans, List<Boolean> ascendingCol) {
        super(operatorKey, requestedParallelism, inp);
        this.setCounterPlans(counterPlans);
        this.setAscendingColumns(ascendingCol);
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            return new ExampleTuple((Tuple)out);
        }
        return (Tuple)out;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitCounter(this);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result inp;
        block1: {
            inp = null;
            do {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block1;
            } while (inp.returnStatus == 1);
            return this.addCounterValue(inp);
        }
        return inp;
    }

    protected Result addCounterValue(Result input) throws ExecException {
        Tuple in = (Tuple)input.result;
        Tuple out = mTupleFactory.newTuple(in.getAll().size() + 2);
        Long sizeBag = 0L;
        int i = 1;
        if (this.isRowNumber() || this.isDenseRank()) {
            if (this.isDenseRank()) {
                this.incrementReduceCounter(ONE);
            }
            out.set(0, this.getLocalCounter());
            this.incrementLocalCounter();
        } else if (!this.isDenseRank()) {
            int positionBag = in.getAll().size() - 1;
            if (in.getType(positionBag) == 120) {
                sizeBag = ((DefaultAbstractBag)in.get(positionBag)).size();
            }
            this.incrementReduceCounter(sizeBag);
            out.set(0, this.getLocalCounter());
            this.addToLocalCounter(sizeBag);
        }
        for (Object o : in) {
            out.set(i++, o);
        }
        out.set(i++, this.getTaskId());
        input.result = this.illustratorMarkup(in, out, 0);
        return input;
    }

    protected void incrementReduceCounter(Long increment) {
        PigMapReduceCounter.PigReduceCounter.incrementCounter(increment);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "POCounter[" + DataType.findTypeName(this.resultType) + "] - " + this.mKey.toString();
    }

    public void setCounterPlans(List<PhysicalPlan> counterPlans) {
        this.counterPlans = counterPlans;
    }

    public List<PhysicalPlan> getCounterPlans() {
        return this.counterPlans;
    }

    public void setAscendingColumns(List<Boolean> mAscCols) {
        this.mAscCols = mAscCols;
    }

    public List<Boolean> getAscendingColumns() {
        return this.mAscCols;
    }

    public void resetLocalCounter() {
        this.localCount = 1L;
    }

    protected Long incrementLocalCounter() {
        Long l = this.localCount;
        Long l2 = this.localCount = Long.valueOf(this.localCount + 1L);
        return l;
    }

    public void setLocalCounter(Long localCount) {
        this.localCount = localCount;
    }

    public Long getLocalCounter() {
        return this.localCount;
    }

    protected void addToLocalCounter(Long sizeBag) {
        POCounter pOCounter = this;
        pOCounter.localCount = pOCounter.localCount + sizeBag;
    }

    public void setTaskId(int taskID) {
        this.taskID = taskID;
    }

    public int getTaskId() {
        return this.taskID;
    }

    public void setIsDenseRank(boolean isDenseRank) {
        this.isDenseRank = isDenseRank;
    }

    public boolean isDenseRank() {
        return this.isDenseRank;
    }

    public void setIsRowNumber(boolean isRowNumber) {
        this.isRowNumber = isRowNumber;
    }

    public boolean isRowNumber() {
        return this.isRowNumber;
    }

    public void setOperationID(String operationID) {
        this.operationID = operationID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    @Override
    public POCounter clone() throws CloneNotSupportedException {
        POCounter clone = (POCounter)super.clone();
        clone.localCount = new Long(this.localCount);
        clone.taskID = new Integer(this.taskID);
        return clone;
    }
}

