/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class REGEX_EXTRACT_ALL
extends EvalFunc<Tuple> {
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    boolean mUseMatches = true;
    String mExpression = null;
    Pattern mPattern = null;

    public REGEX_EXTRACT_ALL() {
    }

    public REGEX_EXTRACT_ALL(String useMatches) {
        this.mUseMatches = Boolean.parseBoolean(useMatches);
    }

    @Override
    public Tuple exec(Tuple input) throws IOException {
        block8: {
            if (input.size() != 2) {
                String msg = "RegexExtractAll : Only 2 parameters are allowed.";
                throw new IOException(msg);
            }
            if (input.get(0) == null) {
                return null;
            }
            try {
                if (input.get(1).equals(this.mExpression)) break block8;
                try {
                    this.mExpression = (String)input.get(1);
                    this.mPattern = Pattern.compile(this.mExpression);
                }
                catch (Exception e) {
                    String msg = "RegexExtractAll : Mal-Formed Regular expression : " + input.get(1);
                    throw new IOException(msg);
                }
            }
            catch (NullPointerException e) {
                String msg = "RegexExtractAll : Regular expression is null";
                throw new IOException(msg);
            }
        }
        Matcher m = this.mPattern.matcher((String)input.get(0));
        if (this.mUseMatches && !m.matches() || !this.mUseMatches && !m.find()) {
            return null;
        }
        Tuple result = tupleFactory.newTuple(m.groupCount());
        for (int i = 0; i < m.groupCount(); ++i) {
            result.set(i, m.group(i + 1));
        }
        return result;
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(this.getClass().getName().toLowerCase(), input), 110));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

