/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.bloom;

import java.util.function.BiFunction;

public class HashProvider {
    public static int[] hashMurmur3(byte[] value, int m, int k) {
        return HashProvider.rejectionSample(HashProvider::murmur3_signed, value, m, k);
    }

    public static int[] hashKirschMitzenmacher(byte[] value, int m, int k) {
        int[] result = new int[k];
        long hash1 = HashProvider.murmur3(0, value);
        long hash2 = HashProvider.murmur3((int)hash1, value);
        for (int i = 0; i < k; ++i) {
            result[i] = (int)((hash1 + (long)i * hash2) % (long)m);
        }
        return result;
    }

    private static long murmur3(int seed, byte[] bytes) {
        return Integer.toUnsignedLong(HashProvider.murmur3_signed(seed, bytes));
    }

    private static int murmur3_signed(int seed, byte[] bytes) {
        int k1;
        int len;
        int h1 = seed;
        int c1 = -862048943;
        int c2 = 461845907;
        int i = 0;
        for (len = bytes.length; len >= 4; len -= 4) {
            k1 = bytes[i++] & 0xFF;
            k1 |= (bytes[i++] & 0xFF) << 8;
            k1 |= (bytes[i++] & 0xFF) << 16;
            k1 |= (bytes[i++] & 0xFF) << 24;
            k1 *= c1;
            k1 = Integer.rotateLeft(k1, 15);
            h1 ^= (k1 *= c2);
            h1 = Integer.rotateLeft(h1, 13);
            h1 = h1 * 5 + -430675100;
        }
        k1 = 0;
        switch (len) {
            case 3: {
                k1 ^= (bytes[i + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 ^= (bytes[i + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 ^= bytes[i] & 0xFF;
                k1 *= c1;
                k1 = Integer.rotateLeft(k1, 15);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (i += len);
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    private static int rejectionSample(int random, int m) {
        if ((random = Math.abs(random)) > Integer.MAX_VALUE - Integer.MAX_VALUE % m || random == Integer.MIN_VALUE) {
            return -1;
        }
        return random % m;
    }

    private static int[] rejectionSample(BiFunction<Integer, byte[], Integer> hashFunction, byte[] value, int m, int k) {
        int[] hashes = new int[k];
        int seed = 0;
        int pos = 0;
        while (pos < k) {
            int hash = HashProvider.rejectionSample(seed = hashFunction.apply(seed, value).intValue(), m);
            if (hash == -1) continue;
            hashes[pos++] = hash;
        }
        return hashes;
    }
}

