/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ProcedureSyncWait {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureSyncWait.class);

    private ProcedureSyncWait() {
    }

    public static Future<byte[]> submitProcedure(ProcedureExecutor<MasterProcedureEnv> procExec, Procedure<MasterProcedureEnv> proc) {
        if (proc.isInitializing()) {
            procExec.submitProcedure(proc);
        }
        return new ProcedureFuture(procExec, proc);
    }

    public static byte[] submitAndWaitProcedure(ProcedureExecutor<MasterProcedureEnv> procExec, Procedure<MasterProcedureEnv> proc) throws IOException {
        if (proc.isInitializing()) {
            procExec.submitProcedure(proc);
        }
        return ProcedureSyncWait.waitForProcedureToCompleteIOE(procExec, proc, Long.MAX_VALUE);
    }

    public static byte[] waitForProcedureToCompleteIOE(ProcedureExecutor<MasterProcedureEnv> procExec, Procedure<?> proc, long timeout) throws IOException {
        try {
            return ProcedureSyncWait.waitForProcedureToComplete(procExec, proc, timeout);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static byte[] waitForProcedureToComplete(final ProcedureExecutor<MasterProcedureEnv> procExec, final Procedure<?> proc, long timeout) throws IOException {
        ProcedureSyncWait.waitFor((MasterProcedureEnv)procExec.getEnvironment(), timeout, "pid=" + proc.getProcId(), new Predicate<Boolean>(){

            @Override
            public Boolean evaluate() throws IOException {
                if (!procExec.isRunning()) {
                    return true;
                }
                ProcedureProtos.ProcedureState state = proc.getState();
                if (state == ProcedureProtos.ProcedureState.INITIALIZING || state == ProcedureProtos.ProcedureState.RUNNABLE) {
                    return false;
                }
                return procExec.isFinished(proc.getProcId());
            }
        });
        if (!procExec.isRunning()) {
            throw new IOException("The Master is Aborting");
        }
        if (proc.hasException()) {
            throw MasterProcedureUtil.unwrapRemoteIOException(proc);
        }
        return proc.getResult();
    }

    public static <T> T waitFor(MasterProcedureEnv env, String purpose, Predicate<T> predicate) throws IOException {
        Configuration conf = env.getMasterConfiguration();
        long waitTime = conf.getLong("hbase.master.wait.on.region", 300000L);
        return ProcedureSyncWait.waitFor(env, waitTime, purpose, predicate);
    }

    public static <T> T waitFor(MasterProcedureEnv env, long waitTime, String purpose, Predicate<T> predicate) throws IOException {
        Configuration conf = env.getMasterConfiguration();
        long waitingTimeForEvents = conf.getInt("hbase.master.event.waiting.time", 1000);
        return ProcedureSyncWait.waitFor(env, waitTime, waitingTimeForEvents, purpose, predicate);
    }

    public static <T> T waitFor(MasterProcedureEnv env, long waitTime, long waitingTimeForEvents, String purpose, Predicate<T> predicate) throws IOException {
        long done = EnvironmentEdgeManager.currentTime() + waitTime;
        if (done <= 0L) {
            done = Long.MAX_VALUE;
        }
        boolean logged = false;
        do {
            T result;
            if ((result = predicate.evaluate()) != null && !result.equals(Boolean.FALSE)) {
                return result;
            }
            try {
                Thread.sleep(waitingTimeForEvents);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while sleeping, waiting on " + purpose);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("waitFor " + purpose);
            } else if (!logged) {
                LOG.debug("waitFor " + purpose);
            }
            logged = true;
        } while (EnvironmentEdgeManager.currentTime() < done && env.isRunning());
        throw new TimeoutIOException("Timed out while waiting on " + purpose);
    }

    protected static void waitMetaRegions(MasterProcedureEnv env) throws IOException {
        int timeout = env.getMasterConfiguration().getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (MetaTableLocator.waitMetaRegionLocation((ZKWatcher)env.getMasterServices().getZooKeeper(), (long)timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    protected static void waitRegionInTransition(MasterProcedureEnv env, List<RegionInfo> regions) throws IOException {
        final RegionStates states = env.getAssignmentManager().getRegionStates();
        for (final RegionInfo region : regions) {
            ProcedureSyncWait.waitFor(env, "regions " + region.getRegionNameAsString() + " in transition", new Predicate<Boolean>(){

                @Override
                public Boolean evaluate() throws IOException {
                    return !states.isRegionInTransition(region);
                }
            });
        }
    }

    protected static MasterQuotaManager getMasterQuotaManager(final MasterProcedureEnv env) throws IOException {
        return ProcedureSyncWait.waitFor(env, "quota manager to be available", new Predicate<MasterQuotaManager>(){

            @Override
            public MasterQuotaManager evaluate() throws IOException {
                return env.getMasterServices().getMasterQuotaManager();
            }
        });
    }

    private static class ProcedureFuture
    implements Future<byte[]> {
        private final ProcedureExecutor<MasterProcedureEnv> procExec;
        private final Procedure<?> proc;
        private boolean hasResult = false;
        private byte[] result = null;

        public ProcedureFuture(ProcedureExecutor<MasterProcedureEnv> procExec, Procedure<?> proc) {
            this.procExec = procExec;
            this.proc = proc;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.hasResult;
        }

        @Override
        public byte[] get() throws InterruptedException, ExecutionException {
            if (this.hasResult) {
                return this.result;
            }
            try {
                return ProcedureSyncWait.waitForProcedureToComplete(this.procExec, this.proc, Long.MAX_VALUE);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.hasResult) {
                return this.result;
            }
            try {
                this.result = ProcedureSyncWait.waitForProcedureToComplete(this.procExec, this.proc, unit.toMillis(timeout));
                this.hasResult = true;
                return this.result;
            }
            catch (TimeoutIOException e) {
                throw new TimeoutException(e.getMessage());
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    @InterfaceAudience.Private
    public static interface Predicate<T> {
        public T evaluate() throws IOException;
    }
}

