/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PushbackReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import sdsu.io.CommentParser;
import sdsu.io.StringReplaceReader;
import sdsu.util.ConversionException;
import sdsu.util.LabeledData;
import sdsu.util.Stringizable;

class LabeledObject
implements Serializable {
    protected static final char COMMENT_CHAR = '#';
    protected static final char METADATA_CHAR = '$';
    protected static final String lineSeparator = System.getProperty("line.separator");
    protected static final String SERIALIZE_SHORT_NAME = "Serializable";
    Object object;
    String metaDataComment;
    String comment;
    String label;
    LabeledData metaData;

    protected LabeledObject() {
        this(null, null, null);
    }

    public LabeledObject(Object object) {
        this(object, null, null);
    }

    public LabeledObject(Object object, String string) {
        this(object, string, null);
    }

    public LabeledObject(Object object, String string, String string2) {
        this.object = object;
        this.label = string;
        this.comment = string2;
    }

    private void appendComment(StringBuffer stringBuffer, String string) {
        block2: {
            if (string == null) break block2;
            try {
                StringReplaceReader stringReplaceReader = new StringReplaceReader(string, lineSeparator, "#" + lineSeparator);
                stringBuffer.append('#');
                stringBuffer.append(stringReplaceReader.contents());
                stringBuffer.append(lineSeparator);
            }
            catch (Exception exception) {}
        }
    }

    private void appendMetaData(StringBuffer stringBuffer, LabeledData labeledData) {
        stringBuffer.append(lineSeparator);
        stringBuffer.append('#');
        stringBuffer.append('$');
        stringBuffer.append(" ");
        stringBuffer.append(labeledData);
        stringBuffer.append(lineSeparator);
    }

    public String asString() throws IOException {
        if (this.object instanceof Stringizable) {
            return this.stringizableToString();
        }
        if (this.object instanceof Properties) {
            return this.propertiesToString();
        }
        if (this.object instanceof String) {
            return this.stringToString();
        }
        if (this.object instanceof Serializable) {
            return this.serializableToString();
        }
        return this.stringToString();
    }

    private LabeledData createMetaDataObject(String string) {
        LabeledData labeledData = new LabeledData();
        ((Hashtable)labeledData).put("class", string);
        if (this.label != null) {
            ((Hashtable)labeledData).put("label", this.label);
        }
        return labeledData;
    }

    private void fromObjectString(String string, String string2) throws IOException {
        try {
            String string3;
            String string4;
            PushbackReader pushbackReader = new PushbackReader(new StringReader(string), 2);
            CommentParser commentParser = new CommentParser(pushbackReader, '#', '$');
            this.metaDataComment = commentParser.readComment();
            this.metaData = commentParser.readDataComment();
            this.comment = commentParser.readComment();
            String string5 = commentParser.readAll();
            if (this.comment == null && this.metaDataComment != null && ((Hashtable)this.metaData).size() == 0) {
                this.comment = this.metaDataComment;
                this.metaDataComment = null;
            }
            if ((string4 = (string3 = this.metaData.getData("class", string2)).toLowerCase()).endsWith("string")) {
                this.object = string5;
            } else if (string4.endsWith("properties")) {
                Properties properties = new Properties();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string5.getBytes());
                properties.load(byteArrayInputStream);
                this.object = properties;
            } else if (string4.endsWith("labeleddata")) {
                this.object = this.makeStringizedObject("sdsu.util.LabeledData", this.metaData, string5);
            } else if (string4.endsWith("labeledtable")) {
                this.object = this.makeStringizedObject("sdsu.util.LabeledTable", this.metaData, string5);
            } else if (string4.endsWith("table")) {
                this.object = this.makeStringizedObject("sdsu.util.Table", this.metaData, string5);
            } else if (string4.endsWith("list")) {
                this.object = this.makeStringizedObject("sdsu.util.List", this.metaData, string5);
            } else if (string4.endsWith(SERIALIZE_SHORT_NAME.toLowerCase())) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string5.getBytes());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.object = objectInputStream.readObject();
            } else {
                this.object = this.makeStringizedObject(string3, this.metaData, string5);
            }
        }
        catch (Exception exception) {
            throw new NoSuchElementException("Error in reading input: " + exception.getMessage());
        }
    }

    public static LabeledObject fromString(String string) throws IOException {
        return LabeledObject.fromString(string, "String");
    }

    public static LabeledObject fromString(String string, String string2) throws IOException {
        LabeledObject labeledObject = new LabeledObject();
        labeledObject.fromObjectString(string, string2);
        return labeledObject;
    }

    public String getComment() {
        return this.comment;
    }

    public String getLabel() {
        return this.label;
    }

    public Object getObject() {
        return this.object;
    }

    private Object makeStringizedObject(String string, LabeledData labeledData, String string2) throws ConversionException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Stringizable stringizable = (Stringizable)Class.forName(string).newInstance();
        stringizable.setMetaData(labeledData);
        stringizable.fromString(string2);
        return stringizable;
    }

    private String propertiesToString() {
        LabeledData labeledData = this.createMetaDataObject(this.object.getClass().getName());
        StringBuffer stringBuffer = new StringBuffer();
        this.appendMetaData(stringBuffer, labeledData);
        this.appendComment(stringBuffer, this.comment);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ((Properties)this.object).save(byteArrayOutputStream, null);
        stringBuffer.append(byteArrayOutputStream.toString());
        return stringBuffer.toString();
    }

    public String serializableShortName() {
        return SERIALIZE_SHORT_NAME;
    }

    public String serializableToString() throws IOException {
        LabeledData labeledData = this.createMetaDataObject(SERIALIZE_SHORT_NAME);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.object);
        objectOutputStream.close();
        StringBuffer stringBuffer = new StringBuffer();
        this.appendMetaData(stringBuffer, labeledData);
        this.appendComment(stringBuffer, this.comment);
        stringBuffer.append(byteArrayOutputStream.toString());
        return stringBuffer.toString();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String shortClassName() {
        String string = this.object.getClass().getName();
        int n = string.lastIndexOf(".");
        String string2 = string.substring(n + 1);
        if (this.object instanceof Stringizable || this.object instanceof Properties || this.object instanceof String) {
            return string2;
        }
        if (this.object instanceof Serializable) {
            return this.serializableShortName();
        }
        return "String";
    }

    private String stringToString() {
        LabeledData labeledData = this.createMetaDataObject("java.lang.String");
        StringBuffer stringBuffer = new StringBuffer();
        this.appendMetaData(stringBuffer, labeledData);
        this.appendComment(stringBuffer, this.comment);
        stringBuffer.append(this.object.toString());
        return stringBuffer.toString();
    }

    private String stringizableToString() {
        StringBuffer stringBuffer = new StringBuffer();
        LabeledData labeledData = ((Stringizable)this.object).getMetaData();
        if (this.label != null) {
            ((Hashtable)labeledData).put("label", this.label);
        }
        this.appendMetaData(stringBuffer, labeledData);
        this.appendComment(stringBuffer, this.comment);
        stringBuffer.append(this.object);
        stringBuffer.append(lineSeparator);
        stringBuffer.append(lineSeparator);
        return stringBuffer.toString();
    }
}

