/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import sdsu.util.TokenCharacters;

public class SimpleTokenizer {
    private TokenCharacters charTable;
    private char lastFoundSeparator;
    private PushbackReader input;
    private static final int EOF = -1;

    public SimpleTokenizer(InputStream inputStream) {
        this(new InputStreamReader(inputStream), new TokenCharacters());
    }

    public SimpleTokenizer(InputStream inputStream, TokenCharacters tokenCharacters) {
        this(new InputStreamReader(inputStream), tokenCharacters);
    }

    public SimpleTokenizer(Reader reader) {
        this(reader, new TokenCharacters());
    }

    public SimpleTokenizer(Reader reader, TokenCharacters tokenCharacters) {
        this.input = new PushbackReader(reader);
        this.charTable = tokenCharacters;
        try {
            this.removeCommentAndWhitespace();
        }
        catch (IOException iOException) {}
    }

    public SimpleTokenizer(String string) {
        this(new StringReader(string));
    }

    public SimpleTokenizer(String string, TokenCharacters tokenCharacters) {
        this(new StringReader(string), tokenCharacters);
    }

    private static final boolean containsChar(String string, char c) {
        int n = -1;
        return string.indexOf(c) != n;
    }

    private String getNextChunk() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.input.read()) != -1) {
            if (this.charTable.isTokenTerminator((char)n)) break;
            stringBuffer.append((char)n);
        }
        if (n != -1) {
            this.input.unread(n);
        }
        return stringBuffer.toString();
    }

    private String getQuotedChunk(char c) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.input.read()) != -1) {
            if (this.charTable.isQuotePair(c, (char)n)) break;
            if (this.charTable.isEscape((char)n)) {
                n = this.input.read();
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        try {
            int n = this.input.read();
            if (n == -1) {
                return false;
            }
            this.input.unread(n);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean isSeparatorNext() throws IOException {
        int n = this.input.read();
        if (this.charTable.isSeparator((char)n)) {
            this.lastFoundSeparator = (char)n;
            return true;
        }
        if (n == -1) {
            return true;
        }
        this.input.unread(n);
        return false;
    }

    public String nextToken() throws IOException {
        String string;
        int n = this.input.read();
        if (this.charTable.isBeginQuote((char)n)) {
            string = this.getQuotedChunk((char)n);
        } else {
            this.input.unread(n);
            string = this.getNextChunk();
        }
        this.removeCommentAndWhitespace();
        if (!this.isSeparatorNext()) {
            throw new IOException("Missing separator ");
        }
        this.removeCommentAndWhitespace();
        return string;
    }

    public String nextToken(String string) throws IOException {
        this.charTable.setSeparatorChars(string);
        return this.nextToken();
    }

    private void removeComment() throws IOException {
        int n;
        do {
            if ((n = this.input.read()) != -1) continue;
            return;
        } while (!this.charTable.isEOL((char)n));
        this.input.unread(n);
    }

    private void removeCommentAndWhitespace() throws IOException {
        int n;
        while ((n = this.input.read()) != -1) {
            if (this.charTable.isComment((char)n)) {
                this.removeComment();
                continue;
            }
            if (this.charTable.isWhitespace((char)n)) continue;
            this.input.unread(n);
            return;
        }
    }

    public char separator() {
        return this.lastFoundSeparator;
    }
}

