/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sdsu.util.ConversionException;
import sdsu.util.LabeledData;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizable;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class Table
implements Cloneable,
Stringizable,
Serializable {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final char DEFAULT_ROW_SEPARATOR = ';';
    private static final char DEFAULT_COLUMN_SEPARATOR = ',';
    private char rowSeparatorChar = (char)59;
    private char columnSeparatorChar = (char)44;
    Object[][] tableElements;
    private int numberOfRows;
    private int numberOfColumns;
    private int capacityIncrement = 10;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(String.valueOf(this.rowSeparatorChar)) + String.valueOf(this.columnSeparatorChar));

    public Table() {
        this(0, 0);
    }

    public Table(int n, int n2) {
        this.numberOfRows = n;
        this.numberOfColumns = n2;
        this.tableElements = new Object[this.numberOfRows + this.capacityIncrement][this.numberOfColumns + this.capacityIncrement];
    }

    public synchronized void addColumn(Vector vector) {
        Table table = Table.fromColumnVector(vector);
        this.addColumns(table);
    }

    public synchronized void addColumns(Table table) {
        this.insertColumnsAt(table, this.numberOfColumns);
    }

    public synchronized void addRow(Vector vector) {
        Table table = Table.fromRowVector(vector);
        this.addRows(table);
    }

    public synchronized void addRows(Table table) {
        this.insertRowsAt(table, this.numberOfRows);
    }

    private void checkBounds(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n >= this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("Row index: " + n + " >= " + this.numberOfRows);
        }
        if (n2 >= this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("Column index: " + n2 + " >= " + this.numberOfColumns);
        }
    }

    public synchronized Object clone() {
        try {
            Table table = (Table)super.clone();
            int n = this.tableElements.length;
            int n2 = this.tableElements[0].length;
            table.tableElements = new Object[n][n2];
            int n3 = 0;
            while (n3 < this.numberOfRows) {
                System.arraycopy(this.tableElements[n3], 0, table.tableElements[n3], 0, this.numberOfColumns);
                ++n3;
            }
            return table;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized Vector columnAt(int n) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(0, n);
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < this.numberOfRows()) {
            vector.addElement(this.tableElements[n2][n]);
            ++n2;
        }
        return vector;
    }

    public synchronized Table columnsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Table table = new Table(this.numberOfRows, 0);
        int n3 = n;
        while (n3 <= n2) {
            table.addColumn(this.columnAt(n3));
            ++n3;
        }
        return table;
    }

    public synchronized Table columnsAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numberOfColumns) {
            if (this.tableElements[n][n3].equals(object)) {
                ++n2;
            }
            ++n3;
        }
        Table table = new Table(0, 0);
        table.insureCapacity(this.numberOfRows, n2);
        int n4 = 0;
        while (n4 < this.numberOfColumns) {
            if (this.tableElements[n][n4].equals(object)) {
                table.addColumn(this.columnAt(n4));
            }
            ++n4;
        }
        return table;
    }

    public boolean contains(Object object) {
        return this.indexOf((Object)object).x != -1;
    }

    public synchronized Object elementAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(n, n2);
        return this.tableElements[n][n2];
    }

    private String elementToString(int n, int n2) {
        if (this.tableElements[n][n2] == null) {
            return "";
        }
        return this.tableElements[n][n2].toString();
    }

    public synchronized Enumeration elements() {
        Vector<Object> vector = new Vector<Object>(this.numberOfColumns * this.numberOfRows);
        int n = 0;
        while (n < this.numberOfRows) {
            int n2 = 0;
            while (n2 < this.numberOfColumns) {
                if (this.tableElements[n][n2] != null) {
                    vector.addElement(this.tableElements[n][n2]);
                }
                ++n2;
            }
            ++n;
        }
        return vector.elements();
    }

    public static Table fromColumnVector(Vector vector) {
        Table table = new Table(vector.size(), 1);
        int n = 0;
        while (n < vector.size()) {
            table.tableElements[n][0] = vector.elementAt(n);
            ++n;
        }
        return table;
    }

    public static Table fromRowVector(Vector vector) {
        Table table = new Table(1, vector.size());
        int n = 0;
        while (n < vector.size()) {
            table.tableElements[0][n] = vector.elementAt(n);
            ++n;
        }
        return table;
    }

    public synchronized void fromString(String string) throws ConversionException {
        try {
            this.load(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new ConversionException("Error in converting string to Table: " + iOException.getMessage());
        }
    }

    public LabeledData getMetaData() {
        String string;
        LabeledData labeledData = this.parseTable.toLabeledData();
        if (this.rowSeparatorChar != ';') {
            string = String.valueOf(this.rowSeparatorChar);
            ((Hashtable)labeledData).put("rowSeparatorChar", string);
        }
        if (this.columnSeparatorChar != ',') {
            string = String.valueOf(this.columnSeparatorChar);
            ((Hashtable)labeledData).put("columnSeparatorChar", string);
        }
        ((Hashtable)labeledData).put("class", this.getClass().getName());
        return labeledData;
    }

    private void growCapacityTo(int n, int n2) {
        Object[][] objectArray = new Object[n][n2];
        int n3 = 0;
        while (n3 < this.numberOfRows) {
            System.arraycopy(this.tableElements[n3], 0, objectArray[n3], 0, this.numberOfColumns);
            ++n3;
        }
        this.tableElements = objectArray;
    }

    public synchronized Point indexOf(Object object) {
        int n = 0;
        while (n < this.numberOfRows) {
            int n2 = 0;
            while (n2 < this.numberOfColumns) {
                if (object.equals(this.tableElements[n][n2])) {
                    return new Point(n, n2);
                }
                ++n2;
            }
            ++n;
        }
        return new Point(-1, -1);
    }

    public synchronized void insertColumnsAt(Table table, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        if (n > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("inserting columns beyond end of the table");
        }
        int n3 = Math.max(table.numberOfRows() - this.numberOfRows, 0);
        int n4 = table.numberOfColumns();
        this.insureCapacity(n3, n4);
        if (n < this.numberOfColumns) {
            n2 = 0;
            while (n2 < this.numberOfRows) {
                System.arraycopy(this.tableElements[n2], n, this.tableElements[n2], n + n4, this.numberOfColumns - n);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.numberOfRows + n3) {
            int n5 = 0;
            while (n5 < n4) {
                this.tableElements[n2][n5 + n] = table.tableElements[n2][n5];
                ++n5;
            }
            ++n2;
        }
        this.numberOfColumns += n4;
        this.numberOfRows += n3;
    }

    public synchronized void insertRowsAt(Table table, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        if (n > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("inserting rows beyond end of the table");
        }
        int n3 = Math.max(table.numberOfColumns() - this.numberOfColumns, 0);
        int n4 = table.numberOfRows();
        this.insureCapacity(n4, n3);
        if (n < this.numberOfRows) {
            System.arraycopy(this.tableElements, n, this.tableElements, n + n4, this.numberOfRows - n);
            n2 = this.tableElements[0].length;
            int n5 = n;
            while (n5 < n + n4) {
                this.tableElements[n5] = new Object[n2];
                ++n5;
            }
        }
        n2 = 0;
        while (n2 < table.numberOfRows()) {
            System.arraycopy(table.tableElements[n2], 0, this.tableElements[n2 + n], 0, table.numberOfColumns());
            ++n2;
        }
        this.numberOfColumns += n3;
        this.numberOfRows += n4;
    }

    private void insureCapacity(int n, int n2) {
        if (n <= this.surplusRows() && n2 <= this.surplusColumns()) {
            return;
        }
        int n3 = n > this.surplusRows() ? this.numberOfRows + this.capacityIncrement + n : this.tableElements.length;
        int n4 = n2 > this.surplusColumns() ? this.numberOfColumns + this.capacityIncrement + n2 : this.tableElements[0].length;
        this.growCapacityTo(n3, n4);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream));
    }

    public synchronized void load(Reader reader) throws IOException {
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(reader, this.parseTable);
        Vector<String> vector = new Vector<String>();
        while (simpleTokenizer.hasMoreTokens()) {
            vector.addElement(simpleTokenizer.nextToken());
            if (simpleTokenizer.separator() != this.rowSeparatorChar) continue;
            this.addRow(vector);
            vector.removeAllElements();
        }
        if (vector.size() > 0) {
            this.addRow(vector);
        }
    }

    public int numberOfColumns() {
        return this.numberOfColumns;
    }

    public int numberOfRows() {
        return this.numberOfRows;
    }

    public synchronized void removeColumnAt(int n) throws ArrayIndexOutOfBoundsException {
        this.removeColumnsAt(n, n);
    }

    public synchronized void removeColumnsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        int n3;
        if (n2 < n || n < 0 || n2 < 0 || n2 >= this.numberOfColumns || n >= this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < this.numberOfColumns) {
            n3 = 0;
            while (n3 < this.numberOfRows) {
                System.arraycopy(this.tableElements[n3], n2 + 1, this.tableElements[n3], n, this.numberOfColumns - n2 - 1);
                ++n3;
            }
        }
        n3 = this.numberOfColumns - (n2 - n) - 1;
        int n4 = 0;
        while (n4 < this.numberOfRows) {
            int n5 = n3;
            while (n5 < this.numberOfColumns) {
                this.tableElements[n4][n5] = null;
                ++n5;
            }
            ++n4;
        }
        this.numberOfColumns = n3;
    }

    public synchronized void removeColumnsAt(Object object, int n) throws ArrayIndexOutOfBoundsException, NullPointerException {
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            if (object.equals(this.elementAt(n, n2))) {
                this.removeColumnsAt(n2, n2);
            }
            ++n2;
        }
    }

    public synchronized void removeRowAt(int n) throws ArrayIndexOutOfBoundsException {
        this.removeRowsAt(n, n);
    }

    public synchronized void removeRowsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < n || n < 0 || n2 < 0 || n2 >= this.numberOfRows || n >= this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 < this.numberOfRows) {
            System.arraycopy(this.tableElements, n2 + 1, this.tableElements, n, this.numberOfRows - n2 - 1);
        }
        int n3 = this.numberOfRows - (n2 - n) - 1;
        int n4 = this.tableElements[0].length;
        int n5 = n3;
        while (n5 < this.numberOfRows) {
            this.tableElements[n5] = new Object[n4];
            ++n5;
        }
        this.numberOfRows = n3;
    }

    public synchronized void removeRowsAt(Object object, int n) throws ArrayIndexOutOfBoundsException, NullPointerException {
        int n2 = 0;
        while (n2 < this.numberOfRows) {
            if (object.equals(this.elementAt(n2, n))) {
                this.removeRowsAt(n2, n2);
            }
            ++n2;
        }
    }

    public synchronized Vector rowAt(int n) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(n, 0);
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            vector.addElement(this.tableElements[n][n2]);
            ++n2;
        }
        return vector;
    }

    public synchronized Table rowsAt(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Table table = new Table(n2 - n + 1, this.numberOfColumns);
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            System.arraycopy(this.tableElements[n4], 0, table.tableElements[n3++], 0, this.numberOfColumns);
            ++n4;
        }
        return table;
    }

    public synchronized Table rowsAt(Object object, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numberOfRows) {
            if (this.tableElements[n3][n].equals(object)) {
                ++n2;
            }
            ++n3;
        }
        Table table = new Table(n2, this.numberOfColumns);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.numberOfRows) {
            if (this.tableElements[n5][n].equals(object)) {
                System.arraycopy(this.tableElements[n5], 0, table.tableElements[n4++], 0, this.numberOfColumns);
            }
            ++n5;
        }
        return table;
    }

    public synchronized void save(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(this.toString(string));
        printWriter.flush();
    }

    public void setColumnSeparatorChar(char c) {
        this.columnSeparatorChar = c;
        this.upDateParseTable();
    }

    public synchronized void setElementAt(Object object, int n, int n2) throws ArrayIndexOutOfBoundsException {
        this.checkBounds(n, n2);
        this.tableElements[n][n2] = object;
    }

    public void setMetaData(LabeledData labeledData) {
        this.parseTable = new TokenCharacters();
        this.parseTable.fromLabeledData(labeledData);
        if (((Hashtable)labeledData).containsKey("rowSeparatorChar")) {
            this.setRowSeparatorChar(labeledData.getData("rowSeparatorChar").charAt(0));
        } else {
            this.setRowSeparatorChar(';');
        }
        if (((Hashtable)labeledData).containsKey("columnSeparatorChar")) {
            this.setColumnSeparatorChar(labeledData.getData("columnSeparatorChar").charAt(0));
        } else {
            this.setColumnSeparatorChar(',');
        }
    }

    public void setRowSeparatorChar(char c) {
        this.rowSeparatorChar = c;
        this.upDateParseTable();
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    public int size() {
        return this.numberOfRows * this.numberOfColumns;
    }

    private int surplusColumns() {
        return this.tableElements[0].length - this.numberOfColumns;
    }

    private int surplusRows() {
        return this.tableElements.length - this.numberOfRows;
    }

    public String toString() {
        return this.toString(null);
    }

    public synchronized String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        String string2 = String.valueOf(String.valueOf(this.rowSeparatorChar)) + NEW_LINE;
        int n = 0;
        while (n < this.numberOfRows) {
            int n2 = 0;
            while (n2 < this.numberOfColumns - 1) {
                stringizer.appendToken((Object)this.elementToString(n, n2), this.columnSeparatorChar);
                ++n2;
            }
            stringizer.appendToken((Object)this.elementToString(n, this.numberOfColumns - 1), string2);
            ++n;
        }
        return stringizer.toString();
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(String.valueOf(this.columnSeparatorChar)) + String.valueOf(this.rowSeparatorChar));
    }
}

