/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.shell.Ls;
import org.apache.hadoop.fs.shell.PathData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class TestLs {
    private static Configuration conf;
    private static FileSystem mockFs;
    private static final Date NOW;

    @BeforeClass
    public static void setup() throws IOException {
        conf = new Configuration();
        conf.set("fs.defaultFS", "mockfs:///");
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
        mockFs = (FileSystem)Mockito.mock(FileSystem.class);
    }

    @Before
    public void resetMock() throws IOException, URISyntaxException {
        Mockito.reset((Object[])new FileSystem[]{mockFs});
        AclStatus mockAclStatus = (AclStatus)Mockito.mock(AclStatus.class);
        Mockito.when((Object)mockAclStatus.getEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)mockFs.getAclStatus((Path)Mockito.any(Path.class))).thenReturn((Object)mockAclStatus);
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)new URI(conf.get("fs.defaultFS")));
    }

    @Test
    public void processOptionsNone() throws IOException {
        LinkedList options = new LinkedList();
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsPathOnly() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-C");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertTrue((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsDirectory() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-d");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertFalse((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsHuman() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-h");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertTrue((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsRecursive() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-R");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertTrue((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsReverse() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-r");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertTrue((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsSize() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-S");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertTrue((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsMtime() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertTrue((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsMtimeSize() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        options.add("-S");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertTrue((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsMtimeSizeReverse() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        options.add("-S");
        options.add("-r");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertTrue((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertTrue((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsAtime() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-u");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertTrue((boolean)ls.isUseAtime());
        Assert.assertFalse((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsDisplayECPolicy() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-e");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertFalse((boolean)ls.isPathOnly());
        Assert.assertTrue((boolean)ls.isDirRecurse());
        Assert.assertFalse((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertFalse((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertFalse((boolean)ls.isOrderTime());
        Assert.assertFalse((boolean)ls.isUseAtime());
        Assert.assertTrue((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processOptionsAll() throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        options.add("-C");
        options.add("-d");
        options.add("-h");
        options.add("-R");
        options.add("-r");
        options.add("-t");
        options.add("-S");
        options.add("-u");
        options.add("-e");
        Ls ls = new Ls();
        ls.processOptions(options);
        Assert.assertTrue((boolean)ls.isPathOnly());
        Assert.assertFalse((boolean)ls.isDirRecurse());
        Assert.assertTrue((boolean)ls.isHumanReadable());
        Assert.assertFalse((boolean)ls.isRecursive());
        Assert.assertTrue((boolean)ls.isOrderReverse());
        Assert.assertFalse((boolean)ls.isOrderSize());
        Assert.assertTrue((boolean)ls.isOrderTime());
        Assert.assertTrue((boolean)ls.isUseAtime());
        Assert.assertTrue((boolean)ls.isDisplayECPolicy());
    }

    @Test
    public void processPathFile() throws IOException {
        TestFile testfile = new TestFile("testDir", "testFile");
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testfile.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList options = new LinkedList();
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println(testfile.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathFiles() throws IOException {
        TestFile testfile01 = new TestFile("testDir01", "testFile01");
        TestFile testfile02 = new TestFile("testDir02", "testFile02");
        TestFile testfile03 = new TestFile("testDir03", "testFile03");
        TestFile testfile04 = new TestFile("testDir04", "testFile04");
        TestFile testfile05 = new TestFile("testDir05", "testFile05");
        TestFile testfile06 = new TestFile("testDir06", "testFile06");
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testfile01.getPathData());
        pathData.add(testfile02.getPathData());
        pathData.add(testfile03.getPathData());
        pathData.add(testfile04.getPathData());
        pathData.add(testfile05.getPathData());
        pathData.add(testfile06.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList options = new LinkedList();
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirectory() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList options = new LinkedList();
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirectories() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory01", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory01", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory01", "testFile03");
        TestFile testDir01 = new TestFile("", "testDirectory01");
        testDir01.setIsDir(true);
        testDir01.addContents(testfile01, testfile02, testfile03);
        TestFile testfile04 = new TestFile("testDirectory02", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory02", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory02", "testFile06");
        TestFile testDir02 = new TestFile("", "testDirectory02");
        testDir02.setIsDir(true);
        testDir02.addContents(testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir01.getPathData());
        pathData.add(testDir02.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList options = new LinkedList();
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 3 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println("Found 3 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderDefault() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile03, testfile05, testfile02, testfile04, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList options = new LinkedList();
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderDefaultReverse() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile03, testfile05, testfile02, testfile04, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-r");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderMtime() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        testfile01.setMtime(NOW.getTime() + 10L);
        testfile02.setMtime(NOW.getTime() + 30L);
        testfile03.setMtime(NOW.getTime() + 20L);
        testfile04.setMtime(NOW.getTime() + 60L);
        testfile05.setMtime(NOW.getTime() + 50L);
        testfile06.setMtime(NOW.getTime() + 40L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderMtimeReverse() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        testfile01.setMtime(NOW.getTime() + 10L);
        testfile02.setMtime(NOW.getTime() + 30L);
        testfile03.setMtime(NOW.getTime() + 20L);
        testfile04.setMtime(NOW.getTime() + 60L);
        testfile05.setMtime(NOW.getTime() + 50L);
        testfile06.setMtime(NOW.getTime() + 40L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        options.add("-r");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirsOrderMtime() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory01", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory01", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory01", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory02", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory02", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory02", "testFile06");
        testfile01.setMtime(NOW.getTime() + 10L);
        testfile02.setMtime(NOW.getTime() + 30L);
        testfile03.setMtime(NOW.getTime() + 20L);
        testfile04.setMtime(NOW.getTime() + 60L);
        testfile05.setMtime(NOW.getTime() + 40L);
        testfile06.setMtime(NOW.getTime() + 50L);
        TestFile testDir01 = new TestFile("", "testDirectory01");
        testDir01.setIsDir(true);
        testDir01.addContents(testfile01, testfile02, testfile03);
        TestFile testDir02 = new TestFile("", "testDirectory02");
        testDir02.setIsDir(true);
        testDir02.addContents(testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir01.getPathData());
        pathData.add(testDir02.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 3 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println("Found 3 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderMtimeYears() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        testfile01.setMtime(NOW.getTime() + Integer.MAX_VALUE);
        testfile02.setMtime(NOW.getTime() + Integer.MIN_VALUE);
        testfile03.setMtime(NOW.getTime() + 0L);
        testfile04.setMtime(NOW.getTime() + Integer.MAX_VALUE + Integer.MAX_VALUE);
        testfile05.setMtime(NOW.getTime() + 0L);
        testfile06.setMtime(NOW.getTime() + Integer.MIN_VALUE + Integer.MIN_VALUE);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderLength() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        long length = 1234567890L;
        testfile01.setLength(length + 10L);
        testfile02.setLength(length + 30L);
        testfile03.setLength(length + 20L);
        testfile04.setLength(length + 60L);
        testfile05.setLength(length + 50L);
        testfile06.setLength(length + 40L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-S");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderLengthReverse() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        long length = 1234567890L;
        testfile01.setLength(length + 10L);
        testfile02.setLength(length + 30L);
        testfile03.setLength(length + 20L);
        testfile04.setLength(length + 60L);
        testfile05.setLength(length + 50L);
        testfile06.setLength(length + 40L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-S");
        options.add("-r");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderLengthLarge() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        long length = 1234567890L;
        testfile01.setLength(length + 6442450941L);
        testfile02.setLength(length + Integer.MAX_VALUE);
        testfile03.setLength(length + 0xFFFFFFFEL);
        testfile04.setLength(length + 0x1FFFFFFFCL);
        testfile05.setLength(length + 0xFFFFFFFEL);
        testfile06.setLength(length + 0L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-S");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineMtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineMtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirectoryAtime() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-u");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineAtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderAtime() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        testfile01.setAtime(NOW.getTime() + 10L);
        testfile02.setAtime(NOW.getTime() + 30L);
        testfile03.setAtime(NOW.getTime() + 20L);
        testfile04.setAtime(NOW.getTime() + 60L);
        testfile05.setAtime(NOW.getTime() + 50L);
        testfile06.setAtime(NOW.getTime() + 40L);
        testfile01.setMtime(NOW.getTime() + 60L);
        testfile02.setMtime(NOW.getTime() + 50L);
        testfile03.setMtime(NOW.getTime() + 20L);
        testfile04.setMtime(NOW.getTime() + 30L);
        testfile05.setMtime(NOW.getTime() + 10L);
        testfile06.setMtime(NOW.getTime() + 40L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        options.add("-u");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineAtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirOrderAtimeReverse() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        testfile01.setAtime(NOW.getTime() + 10L);
        testfile02.setAtime(NOW.getTime() + 30L);
        testfile03.setAtime(NOW.getTime() + 20L);
        testfile04.setAtime(NOW.getTime() + 60L);
        testfile05.setAtime(NOW.getTime() + 50L);
        testfile06.setAtime(NOW.getTime() + 40L);
        testfile01.setMtime(NOW.getTime() + 60L);
        testfile02.setMtime(NOW.getTime() + 50L);
        testfile03.setMtime(NOW.getTime() + 20L);
        testfile04.setMtime(NOW.getTime() + 30L);
        testfile05.setMtime(NOW.getTime() + 10L);
        testfile06.setMtime(NOW.getTime() + 40L);
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-t");
        options.add("-u");
        options.add("-r");
        ls.processOptions(options);
        String lineFormat = TestFile.computeLineFormat(pathData);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println("Found 6 items");
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.formatLineAtime(lineFormat));
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.formatLineAtime(lineFormat));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    @Test
    public void processPathDirectoryPathOnly() throws IOException {
        TestFile testfile01 = new TestFile("testDirectory", "testFile01");
        TestFile testfile02 = new TestFile("testDirectory", "testFile02");
        TestFile testfile03 = new TestFile("testDirectory", "testFile03");
        TestFile testfile04 = new TestFile("testDirectory", "testFile04");
        TestFile testfile05 = new TestFile("testDirectory", "testFile05");
        TestFile testfile06 = new TestFile("testDirectory", "testFile06");
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testfile01, testfile02, testfile03, testfile04, testfile05, testfile06);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        PrintStream out = (PrintStream)Mockito.mock(PrintStream.class);
        Ls ls = new Ls();
        ls.out = out;
        LinkedList<String> options = new LinkedList<String>();
        options.add("-C");
        ls.processOptions(options);
        ls.processArguments(pathData);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{out});
        ((PrintStream)inOrder.verify((Object)out)).println(testfile01.getPath().toString());
        ((PrintStream)inOrder.verify((Object)out)).println(testfile02.getPath().toString());
        ((PrintStream)inOrder.verify((Object)out)).println(testfile03.getPath().toString());
        ((PrintStream)inOrder.verify((Object)out)).println(testfile04.getPath().toString());
        ((PrintStream)inOrder.verify((Object)out)).println(testfile05.getPath().toString());
        ((PrintStream)inOrder.verify((Object)out)).println(testfile06.getPath().toString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{out});
    }

    private static void displayWarningOnLocalFileSystem(boolean shouldDisplay) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.shell.missing.defaultFs.warning", shouldDisplay);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(buf, true);
        Ls ls = new Ls(conf);
        ls.err = err;
        ls.run(new String[]{"file:///."});
        Assert.assertEquals((Object)shouldDisplay, (Object)buf.toString().contains("Warning: fs.defaultFS is not set when running \"ls\" command."));
    }

    @Test
    public void displayWarningsOnLocalFileSystem() throws IOException {
        TestLs.displayWarningOnLocalFileSystem(true);
        TestLs.displayWarningOnLocalFileSystem(false);
    }

    @Test
    public void isDeprecated() {
        Ls ls = new Ls();
        boolean actual = ls.isDeprecated();
        boolean expected = false;
        Assert.assertEquals((String)"Ls.isDeprecated", (Object)expected, (Object)actual);
    }

    @Test
    public void getReplacementCommand() {
        Ls ls = new Ls();
        String actual = ls.getReplacementCommand();
        Object expected = null;
        Assert.assertEquals((String)"Ls.getReplacementCommand", expected, (Object)actual);
    }

    @Test
    public void getName() {
        Ls ls = new Ls();
        String actual = ls.getName();
        String expected = "ls";
        Assert.assertEquals((String)"Ls.getName", (Object)expected, (Object)actual);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void processPathFileDisplayECPolicyWhenUnsupported() throws IOException {
        TestFile testFile = new TestFile("testDirectory", "testFile");
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testFile.getPathData());
        Ls ls = new Ls();
        LinkedList<String> options = new LinkedList<String>();
        options.add("-e");
        ls.processOptions(options);
        ls.processArguments(pathData);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void processPathDirDisplayECPolicyWhenUnsupported() throws IOException {
        TestFile testFile = new TestFile("testDirectory", "testFile");
        TestFile testDir = new TestFile("", "testDirectory");
        testDir.setIsDir(true);
        testDir.addContents(testFile);
        LinkedList<PathData> pathData = new LinkedList<PathData>();
        pathData.add(testDir.getPathData());
        Ls ls = new Ls();
        LinkedList<String> options = new LinkedList<String>();
        options.add("-e");
        ls.processOptions(options);
        ls.processArguments(pathData);
    }

    static /* synthetic */ Date access$200() {
        return NOW;
    }

    static {
        NOW = new Date();
    }

    static class MockFileSystem
    extends FilterFileSystem {
        Configuration conf;

        MockFileSystem() {
            super(mockFs);
        }

        public void initialize(URI uri, Configuration conf) {
            this.conf = conf;
        }

        public Path makeQualified(Path path) {
            return path;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    static class TestFile {
        private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        private static final boolean DEFAULT_ISDIR = false;
        private static final String DEFAULT_MODE = "750";
        private static final int DEFAULT_REPLICATION = 3;
        private static final String DEFAULT_OWNER = "test_owner";
        private static final String DEFAULT_GROUP = "test_group";
        private static final long DEFAULT_LENGTH = 1234567890L;
        private static final long DEFAULT_MTIME = TestLs.access$200().getTime() - 86400000L;
        private static final long DEFAULT_ATIME = TestLs.access$200().getTime() + 86400000L;
        private static final long DEFAULT_BLOCKSIZE = 0x4000000L;
        private String dirname;
        private String filename;
        private boolean isDir;
        private FsPermission permission;
        private int replication;
        private String owner;
        private String group;
        private long length;
        private long mtime;
        private long atime;
        private long blocksize;
        private ArrayList<FileStatus> contents = new ArrayList();
        private Path path = null;
        private FileStatus fileStatus = null;
        private PathData pathData = null;

        public TestFile(String dirname, String filename) {
            this.setDirname(dirname);
            this.setFilename(filename);
            this.setIsDir(false);
            this.setPermission(DEFAULT_MODE);
            this.setReplication(3);
            this.setOwner(DEFAULT_OWNER);
            this.setGroup(DEFAULT_GROUP);
            this.setLength(1234567890L);
            this.setMtime(DEFAULT_MTIME);
            this.setAtime(DEFAULT_ATIME);
            this.setBlocksize(0x4000000L);
        }

        public void setDirname(String dirname) {
            this.dirname = dirname;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public void setIsDir(boolean isDir) {
            this.isDir = isDir;
        }

        public void setPermission(String mode) {
            this.setPermission(new FsPermission(mode));
        }

        public void setPermission(FsPermission permission) {
            this.permission = permission;
        }

        public void setReplication(int replication) {
            this.replication = replication;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public void setMtime(long mtime) {
            this.mtime = mtime;
        }

        public void setAtime(long atime) {
            this.atime = atime;
        }

        public void setBlocksize(long blocksize) {
            this.blocksize = blocksize;
        }

        public void addContents(TestFile ... contents) {
            for (TestFile testFile : contents) {
                this.contents.add(testFile.getFileStatus());
            }
        }

        private String getDirname() {
            return this.dirname;
        }

        private String getFilename() {
            return this.filename;
        }

        private String getPathname() {
            return this.getDirname() + "/" + this.getFilename();
        }

        private boolean isDir() {
            return this.isDir;
        }

        private boolean isFile() {
            return !this.isDir();
        }

        private FsPermission getPermission() {
            return this.permission;
        }

        private int getReplication() {
            return this.replication;
        }

        private String getOwner() {
            return this.owner;
        }

        private String getGroup() {
            return this.group;
        }

        private long getLength() {
            return this.length;
        }

        private long getMtime() {
            return this.mtime;
        }

        private long getAtime() {
            return this.atime;
        }

        private long getBlocksize() {
            return this.blocksize;
        }

        private FileStatus[] getContents() {
            return this.contents.toArray(new FileStatus[0]);
        }

        private String formatLineMtime(String lineFormat) {
            return String.format(lineFormat, this.isDir() ? "d" : "-", this.getPermission(), this.isFile() ? Integer.valueOf(this.getReplication()) : "-", this.getOwner(), this.getGroup(), String.valueOf(this.getLength()), DATE_FORMAT.format(new Date(this.getMtime())), this.getPathname());
        }

        private String formatLineAtime(String lineFormat) {
            return String.format(lineFormat, this.isDir() ? "d" : "-", this.getPermission(), this.isFile() ? Integer.valueOf(this.getReplication()) : "-", this.getOwner(), this.getGroup(), String.valueOf(this.getLength()), DATE_FORMAT.format(new Date(this.getAtime())), this.getPathname());
        }

        public FileStatus getFileStatus() {
            if (this.fileStatus == null) {
                Path path = this.getPath();
                this.fileStatus = new FileStatus(this.getLength(), this.isDir(), this.getReplication(), this.getBlocksize(), this.getMtime(), this.getAtime(), this.getPermission(), this.getOwner(), this.getGroup(), path);
            }
            return this.fileStatus;
        }

        public Path getPath() {
            if (this.path == null) {
                this.path = this.getDirname() != null && !this.getDirname().equals("") ? new Path(this.getDirname(), this.getFilename()) : new Path(this.getFilename());
            }
            return this.path;
        }

        public PathData getPathData() throws IOException {
            if (this.pathData == null) {
                FileStatus fileStatus = this.getFileStatus();
                Path path = this.getPath();
                Mockito.when((Object)mockFs.getFileStatus((Path)ArgumentMatchers.eq((Object)path))).thenReturn((Object)fileStatus);
                this.pathData = new PathData(path.toString(), conf);
                if (this.getContents().length != 0) {
                    Mockito.when((Object)mockFs.listStatus((Path)ArgumentMatchers.eq((Object)path))).thenReturn((Object)this.getContents());
                }
            }
            return this.pathData;
        }

        public static String computeLineFormat(LinkedList<PathData> items) {
            int maxRepl = 3;
            int maxLen = 10;
            int maxOwner = 0;
            int maxGroup = 0;
            for (PathData item : items) {
                FileStatus stat = item.stat;
                maxRepl = TestFile.maxLength(maxRepl, stat.getReplication());
                maxLen = TestFile.maxLength(maxLen, stat.getLen());
                maxOwner = TestFile.maxLength(maxOwner, stat.getOwner());
                maxGroup = TestFile.maxLength(maxGroup, stat.getGroup());
            }
            StringBuilder fmt = new StringBuilder();
            fmt.append("%s%s ");
            fmt.append("%" + maxRepl + "s ");
            fmt.append(maxOwner > 0 ? "%-" + maxOwner + "s " : "%s");
            fmt.append(maxGroup > 0 ? "%-" + maxGroup + "s " : "%s");
            fmt.append("%" + maxLen + "s ");
            fmt.append("%s %s");
            return fmt.toString();
        }

        private static int maxLength(int n, Object value) {
            return Math.max(n, value != null ? String.valueOf(value).length() : 0);
        }
    }
}

