/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.IngressPortBasedResolver;
import org.junit.Assert;
import org.junit.Test;

public class TestIngressPortBasedResolver {
    @Test
    public void testResolver() {
        Configuration conf = new Configuration();
        conf.set("ingress.port.sasl.configured.ports", "444,555,666,777");
        conf.set("ingress.port.sasl.prop.444", "authentication");
        conf.set("ingress.port.sasl.prop.555", "authentication,privacy");
        conf.set("ingress.port.sasl.prop.666", "privacy");
        IngressPortBasedResolver resolver = new IngressPortBasedResolver();
        resolver.setConf(conf);
        Assert.assertEquals((Object)"auth", resolver.getServerProperties(null, 444).get("javax.security.sasl.qop"));
        Assert.assertEquals((Object)"auth,auth-conf", resolver.getServerProperties(null, 555).get("javax.security.sasl.qop"));
        Assert.assertEquals((Object)"auth-conf", resolver.getServerProperties(null, 666).get("javax.security.sasl.qop"));
        Assert.assertEquals((Object)"auth-conf", resolver.getServerProperties(null, 777).get("javax.security.sasl.qop"));
        Assert.assertEquals((Object)"auth", resolver.getServerProperties(null, 888).get("javax.security.sasl.qop"));
    }
}

