/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataStream {
    static MiniDFSCluster cluster;
    static int PACKET_SIZE;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.client-write-packet-size", PACKET_SIZE);
        conf.setInt("dfs.client.slow.io.warning.threshold.ms", 10000);
        conf.setInt("dfs.client.socket-timeout", 60000);
        cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @Test(timeout=60000L)
    public void testDfsClient() throws IOException, InterruptedException {
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataStreamer.class));
        byte[] toWrite = new byte[PACKET_SIZE];
        new Random(1L).nextBytes(toWrite);
        Path path = new Path("/file1");
        DistributedFileSystem dfs = cluster.getFileSystem();
        FSDataOutputStream out = null;
        out = dfs.create(path, false);
        out.write(toWrite);
        out.write(toWrite);
        out.hflush();
        Thread.sleep(15000L);
        out.write(toWrite);
        out.write(toWrite);
        out.hflush();
        Thread.sleep(5000L);
        out.close();
        logs.stopCapturing();
        GenericTestUtils.assertDoesNotMatch((String)logs.getOutput(), (String)"Slow ReadProcessor read fields for block");
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    static {
        PACKET_SIZE = 1024;
    }
}

