/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestRead {
    private final int BLOCK_SIZE = 512;

    private void testEOF(MiniDFSCluster cluster, int fileLength) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("testEOF." + fileLength);
        DFSTestUtil.createFile((FileSystem)fs, path, fileLength, (short)1, -1091584273L);
        FSDataInputStream fis = fs.open(path);
        ByteBuffer empty = ByteBuffer.allocate(0);
        Assert.assertEquals((long)0L, (long)fis.read(empty));
        fis.seek((long)fileLength);
        Assert.assertEquals((long)-1L, (long)fis.read(empty));
        if (fileLength > 512) {
            fis.seek((long)(fileLength - 512 + 1));
            ByteBuffer dbb = ByteBuffer.allocateDirect(512);
            Assert.assertEquals((long)511L, (long)fis.read(dbb));
        }
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testEOFWithBlockReaderLocal() throws Exception {
        try (DFSTestUtil.ShortCircuitTestContext testContext = new DFSTestUtil.ShortCircuitTestContext("testEOFWithBlockReaderLocal");){
            Configuration conf = testContext.newConfiguration();
            conf.setLong("dfs.client.cache.readahead", 512L);
            MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
            this.testEOF(cluster, 1);
            this.testEOF(cluster, 14);
            this.testEOF(cluster, 10000);
            cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testEOFWithRemoteBlockReader() throws Exception {
        Configuration conf = new Configuration();
        conf.setLong("dfs.client.cache.readahead", 512L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        this.testEOF(cluster, 1);
        this.testEOF(cluster, 14);
        this.testEOF(cluster, 10000);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReadReservedPath() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            fs.open(new Path("/.reserved/.inodes/file"));
            Assert.fail((String)"Open a non existing file should fail.");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testInterruptReader() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.fsdataset.factory", DelayedSimulatedFSDataset.Factory.class.getName());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            cluster.waitActive();
            Path file = new Path("/foo");
            DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)1, 0L);
            final FSDataInputStream in = fs.open(file);
            final AtomicBoolean readInterrupted = new AtomicBoolean(false);
            Thread reader = new Thread(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            in.read(new byte[1024], 0, 1024);
                        }
                        catch (IOException e) {
                            if (!(e instanceof ClosedByInterruptException) && !(e instanceof InterruptedIOException)) break block2;
                            readInterrupted.set(true);
                        }
                    }
                }
            });
            reader.start();
            Thread.sleep(1000L);
            reader.interrupt();
            reader.join();
            Assert.assertTrue((boolean)readInterrupted.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    private static class DelayedSimulatedFSDataset
    extends SimulatedFSDataset {
        private volatile boolean isDelayed = true;

        DelayedSimulatedFSDataset(DataNode datanode, DataStorage storage, Configuration conf) {
            super(datanode, storage, conf);
        }

        @Override
        public synchronized InputStream getBlockInputStream(ExtendedBlock b, long seekOffset) throws IOException {
            while (this.isDelayed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            InputStream result = super.getBlockInputStream(b);
            IOUtils.skipFully((InputStream)result, (long)seekOffset);
            return result;
        }

        static class Factory
        extends FsDatasetSpi.Factory<DelayedSimulatedFSDataset> {
            Factory() {
            }

            public DelayedSimulatedFSDataset newInstance(DataNode datanode, DataStorage storage, Configuration conf) throws IOException {
                return new DelayedSimulatedFSDataset(datanode, storage, conf);
            }

            public boolean isSimulated() {
                return true;
            }
        }
    }
}

