/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.protocol.DataNodeUsageReport;
import org.apache.hadoop.hdfs.server.protocol.DataNodeUsageReportUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDNUsageReport {
    private DataNodeUsageReportUtil dnUsageUtil;
    private long bytesWritten;
    private long bytesRead;
    private long writeTime;
    private long readTime;
    private long writeBlock;
    private long readBlock;
    private long timeSinceLastReport;

    @Before
    public void setup() throws IOException {
        this.dnUsageUtil = new DataNodeUsageReportUtil();
    }

    @After
    public void clear() throws IOException {
        this.dnUsageUtil = null;
    }

    @Test(timeout=60000L)
    public void testUsageReport() throws IOException {
        DataNodeUsageReport report = this.dnUsageUtil.getUsageReport(0L, 0L, 0L, 0L, 0L, 0L, 0L);
        Assert.assertEquals((Object)report, (Object)DataNodeUsageReport.EMPTY_REPORT);
        this.bytesWritten = 200L;
        this.bytesRead = 200L;
        this.writeTime = 50L;
        this.readTime = 50L;
        this.writeBlock = 20L;
        this.readBlock = 10L;
        this.timeSinceLastReport = 5L;
        report = this.dnUsageUtil.getUsageReport(this.bytesWritten, this.bytesRead, this.writeTime, this.readTime, this.writeBlock, this.readBlock, this.timeSinceLastReport);
        Assert.assertEquals((long)(this.bytesWritten / this.timeSinceLastReport), (long)report.getBytesWrittenPerSec());
        Assert.assertEquals((long)(this.bytesRead / this.timeSinceLastReport), (long)report.getBytesReadPerSec());
        Assert.assertEquals((long)this.writeTime, (long)report.getWriteTime());
        Assert.assertEquals((long)this.readTime, (long)report.getReadTime());
        Assert.assertEquals((long)(this.writeBlock / this.timeSinceLastReport), (long)report.getBlocksWrittenPerSec());
        Assert.assertEquals((long)(this.readBlock / this.timeSinceLastReport), (long)report.getBlocksReadPerSec());
        DataNodeUsageReport report2 = this.dnUsageUtil.getUsageReport(this.bytesWritten, this.bytesRead, this.writeTime, this.readTime, this.writeBlock, this.readBlock, 0L);
        Assert.assertEquals((Object)report, (Object)report2);
        long bytesWritten2 = 50000L;
        long bytesRead2 = 40000L;
        long writeTime2 = 5000L;
        long readTime2 = 1500L;
        long writeBlock2 = 1000L;
        long readBlock2 = 200L;
        this.timeSinceLastReport = 60L;
        report2 = this.dnUsageUtil.getUsageReport(bytesWritten2, bytesRead2, writeTime2, readTime2, writeBlock2, readBlock2, this.timeSinceLastReport);
        Assert.assertEquals((long)((bytesWritten2 - this.bytesWritten) / this.timeSinceLastReport), (long)report2.getBytesWrittenPerSec());
        Assert.assertEquals((long)((bytesRead2 - this.bytesRead) / this.timeSinceLastReport), (long)report2.getBytesReadPerSec());
        Assert.assertEquals((long)(writeTime2 - this.writeTime), (long)report2.getWriteTime());
        Assert.assertEquals((long)(readTime2 - this.readTime), (long)report2.getReadTime());
        Assert.assertEquals((long)((writeBlock2 - this.writeBlock) / this.timeSinceLastReport), (long)report2.getBlocksWrittenPerSec());
        Assert.assertEquals((long)((readBlock2 - this.readBlock) / this.timeSinceLastReport), (long)report2.getBlocksReadPerSec());
    }
}

