/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAuthorizationContext {
    private String fsOwner = "hdfs";
    private String superGroup = "hdfs";
    private UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)this.fsOwner, (String[])new String[]{this.superGroup});
    private INodeAttributes[] emptyINodeAttributes = new INodeAttributes[0];
    private INodesInPath iip = (INodesInPath)Mockito.mock(INodesInPath.class);
    private int snapshotId = 0;
    private INode[] inodes = new INode[0];
    private byte[][] components = new byte[0][];
    private String path = "";
    private int ancestorIndex = this.inodes.length - 2;

    @Before
    public void setUp() throws IOException {
        Mockito.when((Object)this.iip.getPathSnapshotId()).thenReturn((Object)this.snapshotId);
        Mockito.when((Object)this.iip.getINodesArray()).thenReturn((Object)this.inodes);
        Mockito.when((Object)this.iip.getPathComponents()).thenReturn((Object)this.components);
        Mockito.when((Object)this.iip.getPath()).thenReturn((Object)this.path);
    }

    @Test
    public void testBuilder() {
        String opType = "test";
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("TestAuthorizationContext").build());
        INodeAttributeProvider.AuthorizationContext.Builder builder = new INodeAttributeProvider.AuthorizationContext.Builder();
        builder.fsOwner(this.fsOwner).supergroup(this.superGroup).callerUgi(this.ugi).inodeAttrs(this.emptyINodeAttributes).inodes(this.inodes).pathByNameArr(this.components).snapshotId(this.snapshotId).path(this.path).ancestorIndex(this.ancestorIndex).doCheckOwner(true).ancestorAccess(null).parentAccess(null).access(null).subAccess(null).ignoreEmptyDir(true).operationName(opType).callerContext(CallerContext.getCurrent());
        INodeAttributeProvider.AuthorizationContext authzContext = builder.build();
        TestCase.assertEquals((String)authzContext.getFsOwner(), (String)this.fsOwner);
        TestCase.assertEquals((String)authzContext.getSupergroup(), (String)this.superGroup);
        TestCase.assertEquals((Object)authzContext.getCallerUgi(), (Object)this.ugi);
        TestCase.assertEquals((Object)authzContext.getInodeAttrs(), (Object)this.emptyINodeAttributes);
        TestCase.assertEquals((Object)authzContext.getInodes(), (Object)this.inodes);
        TestCase.assertEquals((Object)authzContext.getPathByNameArr(), (Object)this.components);
        TestCase.assertEquals((int)authzContext.getSnapshotId(), (int)this.snapshotId);
        TestCase.assertEquals((String)authzContext.getPath(), (String)this.path);
        TestCase.assertEquals((int)authzContext.getAncestorIndex(), (int)this.ancestorIndex);
        TestCase.assertEquals((String)authzContext.getOperationName(), (String)opType);
        TestCase.assertEquals((Object)authzContext.getCallerContext(), (Object)CallerContext.getCurrent());
    }

    @Test
    public void testLegacyAPI() throws IOException {
        INodeAttributeProvider.AccessControlEnforcer mockEnforcer = (INodeAttributeProvider.AccessControlEnforcer)Mockito.mock(INodeAttributeProvider.AccessControlEnforcer.class);
        INodeAttributeProvider mockINodeAttributeProvider = (INodeAttributeProvider)Mockito.mock(INodeAttributeProvider.class);
        Mockito.when((Object)mockINodeAttributeProvider.getExternalAccessControlEnforcer((INodeAttributeProvider.AccessControlEnforcer)ArgumentMatchers.any())).thenReturn((Object)mockEnforcer);
        FSPermissionChecker checker = new FSPermissionChecker(this.fsOwner, this.superGroup, this.ugi, mockINodeAttributeProvider, false);
        Mockito.when((Object)this.iip.getPathSnapshotId()).thenReturn((Object)this.snapshotId);
        Mockito.when((Object)this.iip.getINodesArray()).thenReturn((Object)this.inodes);
        Mockito.when((Object)this.iip.getPathComponents()).thenReturn((Object)this.components);
        Mockito.when((Object)this.iip.getPath()).thenReturn((Object)this.path);
        checker.checkPermission(this.iip, true, null, null, null, null, true);
        ((INodeAttributeProvider.AccessControlEnforcer)Mockito.verify((Object)mockEnforcer)).checkPermission(this.fsOwner, this.superGroup, this.ugi, this.emptyINodeAttributes, this.inodes, this.components, this.snapshotId, this.path, this.ancestorIndex, true, null, null, null, null, true);
    }

    @Test
    public void testCheckPermissionWithContextAPI() throws IOException {
        INodeAttributeProvider.AccessControlEnforcer mockEnforcer = (INodeAttributeProvider.AccessControlEnforcer)Mockito.mock(INodeAttributeProvider.AccessControlEnforcer.class);
        INodeAttributeProvider mockINodeAttributeProvider = (INodeAttributeProvider)Mockito.mock(INodeAttributeProvider.class);
        Mockito.when((Object)mockINodeAttributeProvider.getExternalAccessControlEnforcer((INodeAttributeProvider.AccessControlEnforcer)ArgumentMatchers.any())).thenReturn((Object)mockEnforcer);
        FSPermissionChecker checker = new FSPermissionChecker(this.fsOwner, this.superGroup, this.ugi, mockINodeAttributeProvider, true);
        String operationName = "abc";
        FSPermissionChecker.setOperationType((String)operationName);
        checker.checkPermission(this.iip, true, null, null, null, null, true);
        INodeAttributeProvider.AuthorizationContext.Builder builder = new INodeAttributeProvider.AuthorizationContext.Builder();
        builder.fsOwner(this.fsOwner).supergroup(this.superGroup).callerUgi(this.ugi).inodeAttrs(this.emptyINodeAttributes).inodes(this.inodes).pathByNameArr(this.components).snapshotId(this.snapshotId).path(this.path).ancestorIndex(this.ancestorIndex).doCheckOwner(true).ancestorAccess(null).parentAccess(null).access(null).subAccess(null).ignoreEmptyDir(true).operationName(operationName).callerContext(CallerContext.getCurrent());
        INodeAttributeProvider.AuthorizationContext context = builder.build();
        ((INodeAttributeProvider.AccessControlEnforcer)Mockito.verify((Object)mockEnforcer)).checkPermissionWithContext(context);
    }
}

