/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.io.Writable;

public class CustomVertexConfiguration
implements Writable {
    private int numBuckets;
    private TezWork.VertexType vertexType = TezWork.VertexType.AUTO_INITIALIZED_EDGES;
    private int numInputs;
    private String inputName;
    private Map<String, Integer> inputToBucketMap;

    public CustomVertexConfiguration() {
    }

    public CustomVertexConfiguration(int numBuckets, TezWork.VertexType vertexType) {
        this(numBuckets, vertexType, "", 1, null);
    }

    public CustomVertexConfiguration(int numBuckets, TezWork.VertexType vertexType, String inputName, int numInputs, Map<String, Integer> inputToBucketMap) {
        this.numBuckets = numBuckets;
        this.vertexType = vertexType;
        this.numInputs = numInputs;
        this.inputName = inputName;
        this.inputToBucketMap = inputToBucketMap;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.vertexType.ordinal());
        out.writeInt(this.numBuckets);
        out.writeInt(this.numInputs);
        out.writeUTF(this.inputName);
        int sz = this.inputToBucketMap != null ? this.inputToBucketMap.size() : 0;
        out.writeInt(sz);
        if (sz > 0) {
            for (Map.Entry<String, Integer> entry : this.inputToBucketMap.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeInt(entry.getValue());
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.vertexType = TezWork.VertexType.values()[in.readInt()];
        this.numBuckets = in.readInt();
        this.numInputs = in.readInt();
        this.inputName = in.readUTF();
        int sz = in.readInt();
        Preconditions.checkState((sz >= 0 ? 1 : 0) != 0);
        if (sz == 0) {
            this.inputToBucketMap = null;
        } else {
            this.inputToBucketMap = new HashMap<String, Integer>();
            for (int i = 0; i < sz; ++i) {
                this.inputToBucketMap.put(in.readUTF(), in.readInt());
            }
        }
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public TezWork.VertexType getVertexType() {
        return this.vertexType;
    }

    public String getInputName() {
        return this.inputName;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public Map<String, Integer> getInputToBucketMap() {
        return this.inputToBucketMap;
    }
}

