/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

@Description(name="variance, var_pop, var_samp, std, stddev, stddev_pop, stddev_samp", value="_FUNC_(x) - Returns the variance of a set of numbers (vectorized, timestamp)")
public class VectorUDAFVarDecimalComplete
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private transient GenericUDAFVariance.VarianceKind varianceKind = GenericUDAFVariance.VarianceKind.NONE;

    public VectorUDAFVarDecimalComplete() {
    }

    public VectorUDAFVarDecimalComplete(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        Preconditions.checkState((this.mode == GenericUDAFEvaluator.Mode.COMPLETE ? 1 : 0) != 0);
        this.init();
    }

    private void init() {
        String aggregateName = this.vecAggrDesc.getAggrDesc().getGenericUDAFName();
        this.varianceKind = GenericUDAFVariance.VarianceKind.nameMap.get(aggregateName);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        HiveDecimalWritable[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                this.iterateRepeatingNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], inputVector.scale, batchSize);
            }
        } else if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, inputVector.scale, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable value, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.varianceValue(value);
        }
    }

    private void iterateSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            int i = selected[j];
            if (isNull[i]) continue;
            myagg.varianceValue(vector[i]);
        }
    }

    private void iterateSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.varianceValue(vector[selected[i]]);
        }
    }

    private void iterateNoSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.varianceValue(vector[i]);
        }
    }

    private void iterateNoSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, HiveDecimalWritable[] vector, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            myagg.varianceValue(vector[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        DecimalColumnVector inputVector = (DecimalColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        HiveDecimalWritable[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                this.iterateRepeatingNoNulls(myagg, vector[0], inputVector.scale, batchSize);
            }
        } else if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, inputVector.scale, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, inputVector.scale, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, inputVector.scale, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, inputVector.scale, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNulls(Aggregation myagg, HiveDecimalWritable value, short scale, int batchSize) {
        double doubleValue = value.doubleValue();
        for (int i = 0; i < batchSize; ++i) {
            myagg.varianceValue(doubleValue);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            myagg.varianceValue(vector[i]);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.varianceValue(vector[selected[i]]);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            myagg.varianceValue(vector[i]);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, HiveDecimalWritable[] vector, short scale, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            myagg.varianceValue(vector[i]);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((long)(model.object() + model.primitive2() * 3 + model.primitive1()), (long)model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return GenericUDAFVariance.isVarianceFamilyName(name) && inputColVectorType == ColumnVector.Type.DECIMAL && outputColVectorType == ColumnVector.Type.DOUBLE && mode == GenericUDAFEvaluator.Mode.COMPLETE;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (GenericUDAFVariance.isVarianceNull(myagg.count, this.varianceKind)) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        double result = myagg.count > 1L ? GenericUDAFVariance.calculateVarianceFamilyResult(myagg.variance, myagg.count, this.varianceKind) : 0.0;
        outputColVector.vector[batchIndex] = result;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient long count;
        private transient double variance;
        private transient boolean isNull = true;

        public void init() {
            this.isNull = false;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }

        public void varianceValue(double value) {
            if (this.isNull) {
                this.sum = value;
                this.count = 1L;
                this.variance = 0.0;
                this.isNull = false;
            } else {
                this.sum += value;
                ++this.count;
                if (this.count > 1L) {
                    this.variance = GenericUDAFVariance.calculateIntermediate(this.count, this.sum, value, this.variance);
                }
            }
        }

        public void varianceValue(HiveDecimalWritable value) {
            this.varianceValue(value.doubleValue());
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }
    }
}

