/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.WmContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostExecWMEventsSummaryPrinter
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)PostExecWMEventsSummaryPrinter.class.getName());

    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.POST_EXEC_HOOK || hookContext.getHookType() == HookContext.HookType.ON_FAILURE_HOOK);
        HiveConf conf = hookContext.getConf();
        if (!"tez".equals(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            return;
        }
        LOG.info("Executing post execution hook to print workload manager events summary..");
        SessionState.LogHelper console = SessionState.getConsole();
        QueryPlan plan = hookContext.getQueryPlan();
        if (plan == null) {
            return;
        }
        List<TezTask> rootTasks = Utilities.getTezTasks(plan.getRootTasks());
        for (TezTask tezTask : rootTasks) {
            WmContext wmContext = tezTask.getDriverContext().getCtx().getWmContext();
            if (wmContext == null) continue;
            wmContext.printJson(console);
            wmContext.shortPrint(console);
        }
    }
}

