/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.physical.AnnotateRunTimeStatsOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingInferenceOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.CommonJoinResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.CrossProductHandler;
import org.apache.hadoop.hive.ql.optimizer.physical.MapJoinResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.SamplingOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.SkewJoinResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.SortMergeJoinResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.StageIDsRearranger;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class PhysicalOptimizer {
    private PhysicalContext pctx;
    private List<PhysicalPlanResolver> resolvers;

    public PhysicalOptimizer(PhysicalContext pctx, HiveConf hiveConf) {
        this.pctx = pctx;
        this.initialize(hiveConf);
    }

    private void initialize(HiveConf hiveConf) {
        this.resolvers = new ArrayList<PhysicalPlanResolver>();
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVESKEWJOIN)) {
            this.resolvers.add(new SkewJoinResolver());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN)) {
            this.resolvers.add(new CommonJoinResolver());
            if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_TOMAPJOIN)) {
                this.resolvers.add(new SortMergeJoinResolver());
            }
        }
        this.resolvers.add(new MapJoinResolver());
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES)) {
            this.resolvers.add(new MetadataOnlyOptimizer());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVENULLSCANOPTIMIZE)) {
            this.resolvers.add(new NullScanOptimizer());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVESAMPLINGFORORDERBY)) {
            this.resolvers.add(new SamplingOptimizer());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_INFER_BUCKET_SORT)) {
            this.resolvers.add(new BucketingSortingInferenceOptimizer());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_CHECK_CROSS_PRODUCT)) {
            this.resolvers.add(new CrossProductHandler());
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) || HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_VECTORIZATION_ENABLED_OVERRIDE).equalsIgnoreCase("enable")) {
            this.resolvers.add(new Vectorizer());
        }
        if (!"none".equalsIgnoreCase(hiveConf.getVar(HiveConf.ConfVars.HIVESTAGEIDREARRANGE))) {
            this.resolvers.add(new StageIDsRearranger());
        }
        if (this.pctx.getContext().getExplainAnalyze() != null) {
            this.resolvers.add(new AnnotateRunTimeStatsOptimizer());
        }
    }

    public PhysicalContext optimize() throws SemanticException {
        for (PhysicalPlanResolver r : this.resolvers) {
            this.pctx = r.resolve(this.pctx);
        }
        return this.pctx;
    }
}

