/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class FindMax {
    private static void appendZeros(ByteArrayOutputStream baos, int num) {
        for (int i = 0; i < num; ++i) {
            baos.write(0);
        }
    }

    private static Text findMidPoint(Text minBS, Text maxBS) {
        ByteArrayOutputStream startOS = new ByteArrayOutputStream();
        startOS.write(0);
        startOS.write(minBS.getBytes(), 0, minBS.getLength());
        ByteArrayOutputStream endOS = new ByteArrayOutputStream();
        endOS.write(0);
        endOS.write(maxBS.getBytes(), 0, maxBS.getLength());
        if (startOS.size() < endOS.size()) {
            FindMax.appendZeros(startOS, endOS.size() - startOS.size());
        } else if (endOS.size() < startOS.size()) {
            FindMax.appendZeros(endOS, startOS.size() - endOS.size());
        }
        BigInteger min = new BigInteger(startOS.toByteArray());
        BigInteger max = new BigInteger(endOS.toByteArray());
        BigInteger mid = max.subtract(min).divide(BigInteger.valueOf(2L)).add(min);
        byte[] ba = mid.toByteArray();
        Text ret = new Text();
        if (ba.length == startOS.size()) {
            if (ba[0] != 0) {
                throw new RuntimeException();
            }
            ret.set(ba, 1, ba.length - 1);
        } else {
            int expLen = Math.max(minBS.getLength(), maxBS.getLength());
            for (int i = ba.length; i < expLen; ++i) {
                ret.append(new byte[]{0}, 0, 1);
            }
            ret.append(ba, 0, ba.length);
        }
        while (ret.getLength() > 0 && ret.getBytes()[ret.getLength() - 1] == 0 && ret.compareTo((BinaryComparable)minBS) > 0) {
            Text t = new Text();
            t.set(ret.getBytes(), 0, ret.getLength() - 1);
            ret = t;
        }
        return ret;
    }

    private static Text _findMax(Scanner scanner, Text start, boolean inclStart, Text end, boolean inclEnd) {
        Text mid;
        int cmp = start.compareTo((BinaryComparable)end);
        if (cmp >= 0) {
            if (inclStart && inclEnd && cmp == 0) {
                scanner.setRange(new Range(start, true, end, true));
                Iterator<Map.Entry<Key, Value>> iter = scanner.iterator();
                if (iter.hasNext()) {
                    return iter.next().getKey().getRow();
                }
            }
            return null;
        }
        scanner.setRange(new Range(mid, (mid = FindMax.findMidPoint(start, end)).equals((Object)start) ? inclStart : true, end, inclEnd));
        Iterator<Map.Entry<Key, Value>> iter = scanner.iterator();
        if (iter.hasNext()) {
            Key next = iter.next().getKey();
            for (int count = 0; count < 10 && iter.hasNext(); ++count) {
                next = iter.next().getKey();
            }
            if (!iter.hasNext()) {
                return next.getRow();
            }
            Text ret = FindMax._findMax(scanner, next.followingKey(PartialKey.ROW).getRow(), true, end, inclEnd);
            if (ret == null) {
                return next.getRow();
            }
            return ret;
        }
        return FindMax._findMax(scanner, start, inclStart, mid, mid.equals((Object)start) ? inclStart : false);
    }

    private static Text findInitialEnd(Scanner scanner) {
        Text end = new Text(new byte[]{-1, -1, -1, -1});
        scanner.setRange(new Range(end, null));
        while (scanner.iterator().hasNext()) {
            Text t = new Text();
            t.append(end.getBytes(), 0, end.getLength());
            t.append(end.getBytes(), 0, end.getLength());
            end = t;
            scanner.setRange(new Range(end, null));
        }
        return end;
    }

    public static Text findMax(Scanner scanner, Text start, boolean is, Text end, boolean ie) throws TableNotFoundException {
        scanner.setBatchSize(12);
        IteratorSetting cfg = new IteratorSetting(Integer.MAX_VALUE, SortedKeyIterator.class);
        scanner.addScanIterator(cfg);
        if (start == null) {
            start = new Text();
            is = true;
        }
        if (end == null) {
            end = FindMax.findInitialEnd(scanner);
        }
        return FindMax._findMax(scanner, start, is, end, ie);
    }
}

