/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.hadoop.io.Text;

public abstract class RowEncodingIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    public static final String MAX_BUFFER_SIZE_OPT = "maxBufferSize";
    private static final long DEFAULT_MAX_BUFFER_SIZE = Long.MAX_VALUE;
    protected SortedKeyValueIterator<Key, Value> sourceIter;
    private Key topKey = null;
    private Value topValue = null;
    private long maxBufferSize = Long.MAX_VALUE;
    List<Key> keys = new ArrayList<Key>();
    List<Value> values = new ArrayList<Value>();

    public abstract SortedMap<Key, Value> rowDecoder(Key var1, Value var2) throws IOException;

    public abstract Value rowEncoder(List<Key> var1, List<Value> var2) throws IOException;

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        RowEncodingIterator newInstance;
        try {
            newInstance = (RowEncodingIterator)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.sourceIter = this.sourceIter.deepCopy(env);
        newInstance.maxBufferSize = this.maxBufferSize;
        return newInstance;
    }

    private void prepKeys() throws IOException {
        Text currentRow;
        long kvBufSize = 0L;
        if (this.topKey != null) {
            return;
        }
        do {
            if (!this.sourceIter.hasTop()) {
                return;
            }
            currentRow = new Text(this.sourceIter.getTopKey().getRow());
            this.keys.clear();
            this.values.clear();
            while (this.sourceIter.hasTop() && this.sourceIter.getTopKey().getRow().equals((Object)currentRow)) {
                Key sourceTopKey = this.sourceIter.getTopKey();
                Value sourceTopValue = this.sourceIter.getTopValue();
                this.keys.add(new Key(sourceTopKey));
                this.values.add(new Value(sourceTopValue));
                if ((kvBufSize += (long)(sourceTopKey.getSize() + sourceTopValue.getSize() + 128)) > this.maxBufferSize) {
                    throw new BufferOverflowException("Exceeded buffer size of " + this.maxBufferSize + " for row: " + sourceTopKey.getRow().toString());
                }
                this.sourceIter.next();
            }
        } while (!this.filter(currentRow, this.keys, this.values));
        this.topKey = new Key(currentRow);
        this.topValue = this.rowEncoder(this.keys, this.values);
    }

    protected boolean filter(Text currentRow, List<Key> keys, List<Value> values) {
        return true;
    }

    @Override
    public Key getTopKey() {
        return this.topKey;
    }

    @Override
    public Value getTopValue() {
        return this.topValue;
    }

    @Override
    public boolean hasTop() {
        return this.topKey != null;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.sourceIter = source;
        if (options.containsKey(MAX_BUFFER_SIZE_OPT)) {
            this.maxBufferSize = AccumuloConfiguration.getMemoryInBytes(options.get(MAX_BUFFER_SIZE_OPT));
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        String desc = "This iterator encapsulates an entire row of Key/Value pairs into a single Key/Value pair.";
        String bufferDesc = "Maximum buffer size (in accumulo memory spec) to use for buffering keys before throwing a BufferOverflowException.";
        HashMap<String, String> namedOptions = new HashMap<String, String>();
        namedOptions.put(MAX_BUFFER_SIZE_OPT, bufferDesc);
        return new OptionDescriber.IteratorOptions(this.getClass().getSimpleName(), desc, namedOptions, null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        String maxBufferSizeStr = options.get(MAX_BUFFER_SIZE_OPT);
        try {
            AccumuloConfiguration.getMemoryInBytes(maxBufferSizeStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse opt maxBufferSize " + maxBufferSizeStr, e);
        }
        return true;
    }

    @Override
    public void next() throws IOException {
        this.topKey = null;
        this.topValue = null;
        this.prepKeys();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.topKey = null;
        this.topValue = null;
        Key sk = range.getStartKey();
        if (sk != null && sk.getColumnFamilyData().length() == 0 && sk.getColumnQualifierData().length() == 0 && sk.getColumnVisibilityData().length() == 0 && sk.getTimestamp() == Long.MAX_VALUE && !range.isStartKeyInclusive()) {
            Key followingRowKey = sk.followingKey(PartialKey.ROW);
            if (range.getEndKey() != null && followingRowKey.compareTo(range.getEndKey()) > 0) {
                return;
            }
            range = new Range(sk.followingKey(PartialKey.ROW), true, range.getEndKey(), range.isEndKeyInclusive());
        }
        this.sourceIter.seek(range, columnFamilies, inclusive);
        this.prepKeys();
    }
}

