/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.Iterator;

public class PeekingIterator<E>
implements Iterator<E> {
    boolean isInitialized;
    Iterator<E> source;
    E top;

    public PeekingIterator(Iterator<E> source) {
        this.source = source;
        this.top = source.hasNext() ? source.next() : null;
        this.isInitialized = true;
    }

    public PeekingIterator() {
        this.isInitialized = false;
    }

    public PeekingIterator<E> initialize(Iterator<E> source) {
        this.source = source;
        this.top = source.hasNext() ? source.next() : null;
        this.isInitialized = true;
        return this;
    }

    public E peek() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Iterator has not yet been initialized");
        }
        return this.top;
    }

    @Override
    public E next() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Iterator has not yet been initialized");
        }
        E lastPeeked = this.top;
        this.top = this.source.hasNext() ? this.source.next() : null;
        return lastPeeked;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Iterator has not yet been initialized");
        }
        return this.top != null;
    }
}

