/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class SplitFilter
extends Rule {
    public SplitFilter(String n) {
        super(n, false);
    }

    @Override
    public Transformer getNewTransformer() {
        return new SplitFilterTransformer();
    }

    @Override
    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOFilter op2 = new LOFilter(plan);
        plan.add(op2);
        return plan;
    }

    public class SplitFilterTransformer
    extends Transformer {
        private OperatorSubPlan subPlan;

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LOFilter filter = (LOFilter)matched.getSources().get(0);
            LogicalExpressionPlan cond = filter.getFilterPlan();
            LogicalExpression root = (LogicalExpression)cond.getSources().get(0);
            return root instanceof AndExpression && SplitFilter.this.currentPlan.getSoftLinkPredecessors(filter) == null;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.subPlan = new OperatorSubPlan(SplitFilter.this.currentPlan);
            LOFilter filter = (LOFilter)matched.getSources().get(0);
            LogicalExpressionPlan cond = filter.getFilterPlan();
            LogicalExpression root = (LogicalExpression)cond.getSources().get(0);
            if (!(root instanceof AndExpression)) {
                return;
            }
            LogicalExpressionPlan op1 = new LogicalExpressionPlan();
            op1.add((LogicalExpression)cond.getSuccessors(root).get(0));
            this.fillSubPlan(cond, op1, (LogicalExpression)cond.getSuccessors(root).get(0));
            LogicalExpressionPlan op2 = new LogicalExpressionPlan();
            op2.add((LogicalExpression)cond.getSuccessors(root).get(1));
            this.fillSubPlan(cond, op2, (LogicalExpression)cond.getSuccessors(root).get(1));
            filter.setFilterPlan(op1);
            LOFilter filter2 = new LOFilter((LogicalPlan)SplitFilter.this.currentPlan, op2);
            SplitFilter.this.currentPlan.add(filter2);
            Operator succed = null;
            List<Operator> succeds = SplitFilter.this.currentPlan.getSuccessors(filter);
            if (succeds != null) {
                succed = succeds.get(0);
                this.subPlan.add(succed);
                SplitFilter.this.currentPlan.insertBetween(filter, filter2, succed);
            } else {
                SplitFilter.this.currentPlan.connect(filter, 0, filter2, 0);
            }
            this.subPlan.add(filter);
            this.subPlan.add(filter2);
            Iterator<Operator> iter = filter2.getFilterPlan().getOperators();
            while (iter.hasNext()) {
                Operator oper = iter.next();
                if (!(oper instanceof ProjectExpression)) continue;
                ((ProjectExpression)oper).setAttachedRelationalOp(filter2);
            }
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.subPlan;
        }

        private void fillSubPlan(OperatorPlan origPlan, OperatorPlan subPlan, Operator startOp) throws FrontendException {
            List<Operator> l = origPlan.getSuccessors(startOp);
            if (l != null) {
                for (Operator le : l) {
                    subPlan.add(le);
                    subPlan.connect(startOp, le);
                    this.fillSubPlan(origPlan, subPlan, le);
                }
            }
        }
    }
}

