/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.InstanceOperationsImpl;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsZooInstance
implements Instance {
    private final AccumuloConfiguration site = SiteConfiguration.getInstance();
    private static final HdfsZooInstance cachedHdfsZooInstance = new HdfsZooInstance();
    private final ZooCache zooCache;
    private static String instanceId = null;
    private static final Logger log = LoggerFactory.getLogger(HdfsZooInstance.class);
    private final AtomicReference<AccumuloConfiguration> conf = new AtomicReference();

    private HdfsZooInstance() {
        this.zooCache = new ZooCacheFactory().getZooCache(this.site.get(Property.INSTANCE_ZK_HOST), (int)this.site.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT));
    }

    public static Instance getInstance() {
        return cachedHdfsZooInstance;
    }

    public String getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot((Instance)this) + "/root_tablet/location";
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up root tablet location in zoocache.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        byte[] loc = this.zooCache.get(zRootLocPath);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found root tablet at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null) {
            return null;
        }
        return new String(loc, StandardCharsets.UTF_8).split("\\|")[0];
    }

    public List<String> getMasterLocations() {
        String masterLocPath = ZooUtil.getRoot((Instance)this) + "/masters/lock";
        OpTimer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up master location in zoocache.", (Object)Thread.currentThread().getId());
            timer = new OpTimer().start();
        }
        byte[] loc = ZooLock.getLockData((ZooCache)this.zooCache, (String)masterLocPath, null);
        if (timer != null) {
            timer.stop();
            log.trace("tid={} Found master at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
        }
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, StandardCharsets.UTF_8));
    }

    public String getInstanceID() {
        if (instanceId == null) {
            HdfsZooInstance._getInstanceID();
        }
        return instanceId;
    }

    private static synchronized void _getInstanceID() {
        if (instanceId == null) {
            String instanceIdFromFile;
            VolumeManager fs;
            SiteConfiguration acuConf = SiteConfiguration.getInstance();
            try {
                fs = VolumeManagerImpl.get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path instanceIdPath = Accumulo.getAccumuloInstanceIdPath(fs);
            log.trace("Looking for instanceId from {}", (Object)instanceIdPath);
            instanceId = instanceIdFromFile = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)acuConf);
        }
    }

    public String getInstanceName() {
        return InstanceOperationsImpl.lookupInstanceName((ZooCache)this.zooCache, (UUID)UUID.fromString(this.getInstanceID()));
    }

    public String getZooKeepers() {
        return this.site.get(Property.INSTANCE_ZK_HOST);
    }

    public int getZooKeepersSessionTimeOut() {
        return (int)this.site.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
    }

    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return new ConnectorImpl(new ClientContext((Instance)this, new Credentials(principal, token), this.site));
    }

    @Deprecated
    public Connector getConnector(String user, byte[] pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, (AuthenticationToken)new PasswordToken(pass));
    }

    @Deprecated
    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, ByteBufferUtil.toBytes((ByteBuffer)pass));
    }

    @Deprecated
    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, TextUtil.getBytes((Text)new Text(pass.toString())));
    }

    @Deprecated
    public AccumuloConfiguration getConfiguration() {
        AccumuloConfiguration conf = this.conf.get();
        if (conf == null && !this.conf.compareAndSet(null, conf = new ServerConfigurationFactory(this).getConfiguration())) {
            conf = this.conf.get();
        }
        return conf;
    }

    @Deprecated
    public void setConfiguration(AccumuloConfiguration conf) {
        this.conf.set(conf);
    }

    public static void main(String[] args) {
        Instance instance = HdfsZooInstance.getInstance();
        System.out.println("Instance Name: " + instance.getInstanceName());
        System.out.println("Instance ID: " + instance.getInstanceID());
        System.out.println("ZooKeepers: " + instance.getZooKeepers());
        System.out.println("Masters: " + Joiner.on((String)", ").join((Iterable)instance.getMasterLocations()));
    }
}

