/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.compactions;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.mob.compactions.PartitionedMobCompactionRequest;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPartitionedMobCompactionRequest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPartitionedMobCompactionRequest.class);

    @Test
    public void testCompactedPartitionId() {
        String startKey1 = "startKey1";
        String startKey2 = "startKey2";
        String date1 = "date1";
        String date2 = "date2";
        PartitionedMobCompactionRequest.CompactionPartitionId partitionId1 = new PartitionedMobCompactionRequest.CompactionPartitionId(startKey1, date1);
        PartitionedMobCompactionRequest.CompactionPartitionId partitionId2 = new PartitionedMobCompactionRequest.CompactionPartitionId(startKey2, date2);
        PartitionedMobCompactionRequest.CompactionPartitionId partitionId3 = new PartitionedMobCompactionRequest.CompactionPartitionId(startKey1, date2);
        Assert.assertTrue((boolean)partitionId1.equals((Object)partitionId1));
        Assert.assertFalse((boolean)partitionId1.equals((Object)partitionId2));
        Assert.assertFalse((boolean)partitionId1.equals((Object)partitionId3));
        Assert.assertFalse((boolean)partitionId2.equals((Object)partitionId3));
        Assert.assertEquals((Object)startKey1, (Object)partitionId1.getStartKey());
        Assert.assertEquals((Object)date1, (Object)partitionId1.getDate());
    }

    @Test
    public void testCompactedPartition() {
        PartitionedMobCompactionRequest.CompactionPartitionId partitionId = new PartitionedMobCompactionRequest.CompactionPartitionId("startKey1", "date1");
        PartitionedMobCompactionRequest.CompactionPartition partition = new PartitionedMobCompactionRequest.CompactionPartition(partitionId);
        FileStatus file = new FileStatus(1L, false, 1, 1024L, 1L, new Path("/test"));
        partition.addFile(file);
        Assert.assertEquals((Object)file, partition.listFiles().get(0));
    }
}

