/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.rm.container;

import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.tez.dag.app.rm.container.AMContainerEvent;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.records.TaskAttemptTerminationCause;
import org.apache.tez.serviceplugins.api.ContainerEndReason;

public class AMContainerEventCompleted
extends AMContainerEvent {
    private final int exitStatus;
    private final String diagnostics;
    private final TaskAttemptTerminationCause errCause;

    public AMContainerEventCompleted(ContainerId containerId, int exitStatus, String diagnostics, TaskAttemptTerminationCause errCause) {
        super(containerId, AMContainerEventType.C_COMPLETED);
        this.exitStatus = exitStatus;
        this.diagnostics = diagnostics;
        this.errCause = errCause;
    }

    public boolean isPreempted() {
        return this.exitStatus == -102 || this.errCause == TaskAttemptTerminationCause.INTERNAL_PREEMPTION;
    }

    public boolean isDiskFailed() {
        return this.exitStatus == -101;
    }

    public boolean isSystemAction() {
        return this.isPreempted() || this.isDiskFailed();
    }

    public String getDiagnostics() {
        return this.diagnostics;
    }

    public int getContainerExitStatus() {
        return this.exitStatus;
    }

    public TaskAttemptTerminationCause getTerminationCause() {
        return this.errCause;
    }

    public ContainerEndReason getContainerEndReason() {
        if (this.errCause != null) {
            switch (this.errCause) {
                case INTERNAL_PREEMPTION: {
                    return ContainerEndReason.INTERNAL_PREEMPTION;
                }
                case EXTERNAL_PREEMPTION: {
                    return ContainerEndReason.EXTERNAL_PREEMPTION;
                }
                case FRAMEWORK_ERROR: {
                    return ContainerEndReason.FRAMEWORK_ERROR;
                }
                case APPLICATION_ERROR: {
                    return ContainerEndReason.APPLICATION_ERROR;
                }
                case CONTAINER_LAUNCH_FAILED: {
                    return ContainerEndReason.LAUNCH_FAILED;
                }
                case NODE_FAILED: {
                    return ContainerEndReason.NODE_FAILED;
                }
                case CONTAINER_EXITED: {
                    return ContainerEndReason.COMPLETED;
                }
            }
            return ContainerEndReason.OTHER;
        }
        return ContainerEndReason.OTHER;
    }
}

