/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;

public abstract class PreemptionCandidatesSelector {
    protected CapacitySchedulerPreemptionContext preemptionContext;
    protected ResourceCalculator rc;
    private long maximumKillWaitTime = -1L;

    PreemptionCandidatesSelector(CapacitySchedulerPreemptionContext preemptionContext) {
        this.preemptionContext = preemptionContext;
        this.rc = preemptionContext.getResourceCalculator();
    }

    public abstract Map<ApplicationAttemptId, Set<RMContainer>> selectCandidates(Map<ApplicationAttemptId, Set<RMContainer>> var1, Resource var2, Resource var3);

    @VisibleForTesting
    static void sortContainers(List<RMContainer> containers) {
        Collections.sort(containers, new Comparator<RMContainer>(){

            @Override
            public int compare(RMContainer a, RMContainer b) {
                int schedKeyComp = b.getAllocatedSchedulerKey().compareTo(a.getAllocatedSchedulerKey());
                if (schedKeyComp != 0) {
                    return schedKeyComp;
                }
                return b.getContainerId().compareTo(a.getContainerId());
            }
        });
    }

    public long getMaximumKillWaitTimeMs() {
        if (this.maximumKillWaitTime > 0L) {
            return this.maximumKillWaitTime;
        }
        return this.preemptionContext.getDefaultMaximumKillWaitTimeout();
    }

    public void setMaximumKillWaitTime(long maximumKillWaitTime) {
        this.maximumKillWaitTime = maximumKillWaitTime;
    }
}

