/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivityState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWSConsts;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ActivityNodeInfo;

public final class ActivitiesUtils {
    private ActivitiesUtils() {
    }

    public static List<ActivityNodeInfo> getRequestActivityNodeInfos(List<ActivityNode> activityNodes, RMWSConsts.ActivitiesGroupBy groupBy) {
        if (activityNodes == null) {
            return null;
        }
        if (groupBy == RMWSConsts.ActivitiesGroupBy.DIAGNOSTIC) {
            Map groupingResults = activityNodes.stream().filter(e -> e.getNodeId() != null).collect(Collectors.groupingBy(ActivityNode::getState, Collectors.groupingBy(ActivityNode::getShortDiagnostic, Collectors.mapping(e -> e.getNodeId() == null ? "" : e.getNodeId().toString(), Collectors.toList()))));
            return groupingResults.entrySet().stream().flatMap(stateMap -> ((Map)stateMap.getValue()).entrySet().stream().map(diagMap -> new ActivityNodeInfo((ActivityState)((Object)((Object)((Object)stateMap.getKey()))), ((String)diagMap.getKey()).isEmpty() ? null : (String)diagMap.getKey(), (List)diagMap.getValue()))).collect(Collectors.toList());
        }
        return activityNodes.stream().filter(e -> e.getNodeId() != null).map(e -> new ActivityNodeInfo(e.getName(), e.getState(), e.getDiagnostic(), e.getNodeId())).collect(Collectors.toList());
    }
}

