/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAutoCreatedLeafQueue
extends LeafQueue {
    protected AbstractManagedParentQueue parent;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAutoCreatedLeafQueue.class);

    public AbstractAutoCreatedLeafQueue(CapacitySchedulerContext cs, String queueName, AbstractManagedParentQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.parent = parent;
    }

    public AbstractAutoCreatedLeafQueue(CapacitySchedulerContext cs, CapacitySchedulerConfiguration leafQueueConfigs, String queueName, AbstractManagedParentQueue parent, CSQueue old) throws IOException {
        super(cs, leafQueueConfigs, queueName, parent, old);
        this.parent = parent;
    }

    public void setEntitlement(QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        this.setEntitlement("", entitlement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntitlement(String nodeLabel, QueueEntitlement entitlement) throws SchedulerDynamicEditException {
        this.writeLock.lock();
        try {
            float capacity = entitlement.getCapacity();
            if (capacity < 0.0f || capacity > 1.0f) {
                throw new SchedulerDynamicEditException("Capacity demand is not in the [0,1] range: " + capacity);
            }
            this.setCapacity(nodeLabel, capacity);
            this.setAbsoluteCapacity(nodeLabel, this.getParent().getQueueCapacities().getAbsoluteCapacity(nodeLabel) * this.getQueueCapacities().getCapacity(nodeLabel));
            this.setMaxCapacity(nodeLabel, entitlement.getMaxCapacity());
            LOG.debug("successfully changed to {} for queue {}", (Object)Float.valueOf(capacity), (Object)this.getQueuePath());
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, this.csContext.getClusterResource(), this, this.labelManager, nodeLabel);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void setupConfigurableCapacities(QueueCapacities queueCapacities) {
        CSQueueUtils.updateAndCheckCapacitiesByLabel(this.getQueuePath(), queueCapacities, this.parent == null ? null : this.parent.getQueueCapacities());
    }
}

