/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.provider;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.environmentprovider.PinotEnvironmentProvider;
import org.apache.pinot.spi.utils.JsonUtils;

public class AzureEnvironmentProvider
implements PinotEnvironmentProvider {
    protected static final String MAX_RETRY = "maxRetry";
    protected static final String IMDS_ENDPOINT = "imdsEndpoint";
    protected static final String CONNECTION_TIMEOUT_MILLIS = "connectionTimeoutMillis";
    protected static final String REQUEST_TIMEOUT_MILLIS = "requestTimeoutMillis";
    private static final String COMPUTE = "compute";
    private static final String METADATA = "Metadata";
    private static final String PLATFORM_FAULT_DOMAIN = "platformFaultDomain";
    private int _maxRetry;
    private String _imdsEndpoint;
    private CloseableHttpClient _closeableHttpClient;

    public AzureEnvironmentProvider() {
    }

    public void init(PinotConfiguration pinotConfiguration) {
        Preconditions.checkArgument((0 < Integer.parseInt(pinotConfiguration.getProperty(MAX_RETRY)) ? 1 : 0) != 0, (Object)"[AzureEnvironmentProvider]: maxRetry cannot be less than or equal to 0");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)pinotConfiguration.getProperty(IMDS_ENDPOINT)) ? 1 : 0) != 0, (Object)"[AzureEnvironmentProvider]: imdsEndpoint should not be null or empty");
        this._maxRetry = Integer.parseInt(pinotConfiguration.getProperty(MAX_RETRY));
        this._imdsEndpoint = pinotConfiguration.getProperty(IMDS_ENDPOINT);
        int connectionTimeoutMillis = Integer.parseInt(pinotConfiguration.getProperty(CONNECTION_TIMEOUT_MILLIS));
        int requestTimeoutMillis = Integer.parseInt(pinotConfiguration.getProperty(REQUEST_TIMEOUT_MILLIS));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.of((long)connectionTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS)).setResponseTimeout(Timeout.of((long)requestTimeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS)).build();
        DefaultHttpRequestRetryStrategy httpRequestRetry = new DefaultHttpRequestRetryStrategy(this._maxRetry, TimeValue.ofSeconds((long)1L));
        this._closeableHttpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRetryStrategy((HttpRequestRetryStrategy)httpRequestRetry).build();
    }

    @VisibleForTesting
    public AzureEnvironmentProvider(int maxRetry, String imdsEndpoint, CloseableHttpClient closeableHttpClient) {
        this._maxRetry = maxRetry;
        this._imdsEndpoint = imdsEndpoint;
        this._closeableHttpClient = (CloseableHttpClient)Preconditions.checkNotNull((Object)closeableHttpClient, (Object)"[AzureEnvironmentProvider]: Closeable Http Client cannot be null");
    }

    @VisibleForTesting
    public String getFailureDomain() {
        String responsePayload = this.getAzureInstanceMetadata();
        try {
            JsonNode jsonNode = JsonUtils.stringToJsonNode((String)responsePayload);
            JsonNode computeNode = jsonNode.path(COMPUTE);
            if (computeNode.isMissingNode()) {
                throw new RuntimeException("[AzureEnvironmentProvider]: Compute node is missing in the payload. Cannot retrieve failure domain information");
            }
            JsonNode platformFailureDomainNode = computeNode.path(PLATFORM_FAULT_DOMAIN);
            if (platformFailureDomainNode.isMissingNode() || !platformFailureDomainNode.isTextual()) {
                throw new RuntimeException("[AzureEnvironmentProvider]: Json node platformFaultDomain is missing or is invalid. No failure domain information retrieved for given server instance");
            }
            return platformFailureDomainNode.textValue();
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("[AzureEnvironmentProvider]: Errors when parsing response payload from Azure Instance Metadata Service: %s", responsePayload), ex);
        }
    }

    @VisibleForTesting
    private String getAzureInstanceMetadata() {
        HttpGet httpGet = new HttpGet(this._imdsEndpoint);
        httpGet.setHeader(METADATA, (Object)Boolean.TRUE.toString());
        try {
            CloseableHttpResponse closeableHttpResponse = this._closeableHttpClient.execute((ClassicHttpRequest)httpGet);
            if (closeableHttpResponse == null) {
                throw new RuntimeException("[AzureEnvironmentProvider]: Response is null. Please verify the imds endpoint");
            }
            int statusCode = closeableHttpResponse.getCode();
            if (statusCode != 200) {
                String errorMsg = String.format("[AzureEnvironmentProvider]: Failed to retrieve azure instance metadata. Response Status code: %s", statusCode);
                throw new RuntimeException(errorMsg);
            }
            return EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("[AzureEnvironmentProvider]: Failed to retrieve metadata from Azure Instance Metadata Service %s", this._imdsEndpoint), ex);
        }
    }
}

