/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractor;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordExtractorConfig;
import org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CSVRecordReader
implements RecordReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVRecordReader.class);
    private static final Map<String, CSVFormat> CSV_FORMAT_MAP = new HashMap<String, CSVFormat>();
    private File _dataFile;
    private CSVRecordReaderConfig _config;
    private CSVFormat _format;
    private BufferedReader _reader;
    private CSVParser _parser;
    private List<String> _columns;
    private Iterator<CSVRecord> _iterator;
    private CSVRecordExtractor _recordExtractor;
    private int _nextLineId;
    private int _numSkippedLines;
    private RuntimeException _exceptionInHasNext;
    private CSVFormat _recoveryFormat;

    private static String canonicalize(String format) {
        return StringUtils.remove((String)format, (char)'_').toUpperCase();
    }

    private static CSVFormat getCSVFormat(@Nullable String format) {
        if (format == null) {
            return CSVFormat.DEFAULT;
        }
        CSVFormat csvFormat = CSV_FORMAT_MAP.get(CSVRecordReader.canonicalize(format));
        if (csvFormat != null) {
            return csvFormat;
        }
        LOGGER.warn("Failed to find CSV format for: {}, using DEFAULT format", (Object)format);
        return CSVFormat.DEFAULT;
    }

    public void init(File dataFile, @Nullable Set<String> fieldsToRead, @Nullable RecordReaderConfig recordReaderConfig) throws IOException {
        boolean hasNext;
        this._dataFile = dataFile;
        this._config = recordReaderConfig != null ? (CSVRecordReaderConfig)recordReaderConfig : new CSVRecordReaderConfig();
        this._format = this.getCSVFormat();
        this._reader = RecordReaderUtils.getBufferedReader((File)this._dataFile);
        this._parser = this._format.parse(this._reader);
        this._columns = this._parser.getHeaderNames();
        this._iterator = this._parser.iterator();
        this._recordExtractor = this.getRecordExtractor(fieldsToRead);
        this._nextLineId = (int)this._parser.getCurrentLineNumber();
        try {
            hasNext = this._iterator.hasNext();
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to read first record from file: " + String.valueOf(this._dataFile), e);
        }
        if (hasNext) {
            CSVRecord record = this._iterator.next();
            if (record.size() > 1 && this._columns.size() <= 1) {
                throw new IllegalStateException("Header does not contain the configured delimiter");
            }
            this._reader.close();
            this._reader = RecordReaderUtils.getBufferedReader((File)this._dataFile);
            this._parser = this._format.parse(this._reader);
            this._iterator = this._parser.iterator();
        }
    }

    private CSVFormat getCSVFormat() {
        CSVFormat.Builder builder = CSVRecordReader.getCSVFormat(this._config.getFileFormat()).builder().setHeader(new String[0]).setDelimiter(this._config.getDelimiter()).setIgnoreEmptyLines(this._config.isIgnoreEmptyLines()).setIgnoreSurroundingSpaces(this._config.isIgnoreSurroundingSpaces()).setQuote(this._config.getQuoteCharacter());
        if (this._config.getCommentMarker() != null) {
            builder.setCommentMarker(this._config.getCommentMarker());
        }
        if (this._config.getEscapeCharacter() != null) {
            builder.setEscape(this._config.getEscapeCharacter());
        }
        if (this._config.getNullStringValue() != null) {
            builder.setNullString(this._config.getNullStringValue());
        }
        if (this._config.getQuoteMode() != null) {
            builder.setQuoteMode(QuoteMode.valueOf(this._config.getQuoteMode()));
        }
        if (this._config.getRecordSeparator() != null) {
            builder.setRecordSeparator(this._config.getRecordSeparator());
        }
        CSVFormat format = builder.build();
        String header = this._config.getHeader();
        if (header == null) {
            return format;
        }
        try (CSVParser parser = CSVParser.parse(header, format);){
            format = builder.setHeader(parser.getHeaderNames().toArray(new String[0])).setSkipHeaderRecord(this._config.isSkipHeader()).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse header from line: " + header, e);
        }
        return format;
    }

    private CSVRecordExtractor getRecordExtractor(@Nullable Set<String> fieldsToRead) {
        CSVRecordExtractorConfig recordExtractorConfig = new CSVRecordExtractorConfig();
        if (this._config.isMultiValueDelimiterEnabled()) {
            recordExtractorConfig.setMultiValueDelimiter(Character.valueOf(this._config.getMultiValueDelimiter()));
        }
        recordExtractorConfig.setColumnNames(new HashSet<String>(this._columns));
        CSVRecordExtractor recordExtractor = new CSVRecordExtractor();
        recordExtractor.init(fieldsToRead, recordExtractorConfig);
        return recordExtractor;
    }

    public List<String> getColumns() {
        return this._columns;
    }

    public boolean hasNext() {
        try {
            return this._iterator.hasNext();
        }
        catch (RuntimeException e) {
            if (this._config.isStopOnError()) {
                LOGGER.warn("Caught exception while reading CSV file: {}, stopping processing", (Object)this._dataFile, (Object)e);
                return false;
            }
            this._exceptionInHasNext = e;
            return true;
        }
    }

    public GenericRow next(GenericRow reuse) throws IOException {
        if (this._exceptionInHasNext != null) {
            this._reader.close();
            this._reader = RecordReaderUtils.getBufferedReader((File)this._dataFile);
            this._numSkippedLines = this._nextLineId + 1;
            for (int i = 0; i < this._numSkippedLines; ++i) {
                this._reader.readLine();
            }
            this._nextLineId = this._numSkippedLines;
            if (this._recoveryFormat == null) {
                this._recoveryFormat = this._format.builder().setHeader(this._columns.toArray(new String[0])).setSkipHeaderRecord(false).build();
            }
            this._parser = this._recoveryFormat.parse(this._reader);
            this._iterator = this._parser.iterator();
            RuntimeException exception = this._exceptionInHasNext;
            this._exceptionInHasNext = null;
            LOGGER.warn("Caught exception while reading CSV file: {}, recovering from line: {}", new Object[]{this._dataFile, this._numSkippedLines, exception});
            throw exception;
        }
        CSVRecord record = this._iterator.next();
        this._recordExtractor.extract(record, reuse);
        this._nextLineId = this._numSkippedLines + (int)this._parser.getCurrentLineNumber();
        return reuse;
    }

    public void rewind() throws IOException {
        this._reader.close();
        this._reader = RecordReaderUtils.getBufferedReader((File)this._dataFile);
        this._parser = this._format.parse(this._reader);
        this._iterator = this._parser.iterator();
        this._nextLineId = (int)this._parser.getCurrentLineNumber();
        this._numSkippedLines = 0;
    }

    public void close() throws IOException {
        if (this._reader != null) {
            this._reader.close();
        }
    }

    static {
        for (CSVFormat.Predefined format : CSVFormat.Predefined.values()) {
            CSV_FORMAT_MAP.put(CSVRecordReader.canonicalize(format.name()), format.getFormat());
        }
    }
}

