/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AvroCompatibilityChecker {
    private static final Logger log = LoggerFactory.getLogger(AvroCompatibilityChecker.class);
    private static final SchemaValidator BACKWARD_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateLatest();
    public static final AvroCompatibilityChecker BACKWARD_CHECKER = new AvroCompatibilityChecker(BACKWARD_VALIDATOR);
    private static final SchemaValidator FORWARD_VALIDATOR = new SchemaValidatorBuilder().canBeReadStrategy().validateLatest();
    public static final AvroCompatibilityChecker FORWARD_CHECKER = new AvroCompatibilityChecker(FORWARD_VALIDATOR);
    private static final SchemaValidator FULL_VALIDATOR = new SchemaValidatorBuilder().mutualReadStrategy().validateLatest();
    public static final AvroCompatibilityChecker FULL_CHECKER = new AvroCompatibilityChecker(FULL_VALIDATOR);
    private static final SchemaValidator BACKWARD_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().canReadStrategy().validateAll();
    public static final AvroCompatibilityChecker BACKWARD_TRANSITIVE_CHECKER = new AvroCompatibilityChecker(BACKWARD_TRANSITIVE_VALIDATOR);
    private static final SchemaValidator FORWARD_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().canBeReadStrategy().validateAll();
    public static final AvroCompatibilityChecker FORWARD_TRANSITIVE_CHECKER = new AvroCompatibilityChecker(FORWARD_TRANSITIVE_VALIDATOR);
    private static final SchemaValidator FULL_TRANSITIVE_VALIDATOR = new SchemaValidatorBuilder().mutualReadStrategy().validateAll();
    public static final AvroCompatibilityChecker FULL_TRANSITIVE_CHECKER = new AvroCompatibilityChecker(FULL_TRANSITIVE_VALIDATOR);
    private static final SchemaValidator NO_OP_VALIDATOR = new SchemaValidator(){

        @Override
        public void validate(Schema schema2, Iterable<Schema> schemas) throws SchemaValidationException {
        }
    };
    public static final AvroCompatibilityChecker NO_OP_CHECKER = new AvroCompatibilityChecker(NO_OP_VALIDATOR);
    private final SchemaValidator validator;

    private AvroCompatibilityChecker(SchemaValidator validator) {
        this.validator = validator;
    }

    public boolean isCompatible(Schema newSchema, Schema latestSchema) {
        return this.isCompatible(newSchema, Collections.singletonList(latestSchema));
    }

    public boolean isCompatible(Schema newSchema, List<Schema> previousSchemas) {
        ArrayList<Schema> previousSchemasCopy = new ArrayList<Schema>(previousSchemas);
        try {
            Collections.reverse(previousSchemasCopy);
            this.validator.validate(newSchema, previousSchemasCopy);
        }
        catch (SchemaValidationException e) {
            return false;
        }
        catch (Exception e) {
            log.error("Unexpected exception during compatibility check", e);
            return false;
        }
        return true;
    }
}

