/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.Collections;
import java.util.List;

public class SchemaMetadata {
    private int id;
    private int version;
    private String schemaType;
    private String schema;
    private List<SchemaReference> references;
    private Metadata metadata = null;
    private RuleSet ruleSet = null;

    public SchemaMetadata(int id, int version, String schema2) {
        this(id, version, "AVRO", Collections.emptyList(), schema2);
    }

    public SchemaMetadata(int id, int version, String schemaType, List<SchemaReference> references, String schema2) {
        this.id = id;
        this.version = version;
        this.schemaType = schemaType;
        this.schema = schema2;
        this.references = references;
    }

    public SchemaMetadata(Schema schema2) {
        this.id = schema2.getId();
        this.version = schema2.getVersion();
        this.schemaType = schema2.getSchemaType();
        this.schema = schema2.getSchema();
        this.references = schema2.getReferences();
        this.metadata = schema2.getMetadata();
        this.ruleSet = schema2.getRuleSet();
    }

    public int getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<SchemaReference> getReferences() {
        return this.references;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }
}

