/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pinot.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Compatibility check response")
public class CompatibilityCheckResponse {
    private boolean isCompatible;
    private List<String> messages = null;

    public static CompatibilityCheckResponse fromJson(String json) throws IOException {
        return JacksonMapper.INSTANCE.readValue(json, CompatibilityCheckResponse.class);
    }

    @Schema(description="Whether the compared schemas are compatible")
    @JsonProperty(value="is_compatible")
    public boolean getIsCompatible() {
        return this.isCompatible;
    }

    @JsonProperty(value="is_compatible")
    public void setIsCompatible(boolean isCompatible) {
        this.isCompatible = isCompatible;
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString(this);
    }

    @Schema(description="Error messages", example="[]")
    @JsonProperty(value="messages")
    public List<String> getMessages() {
        return this.messages;
    }

    @JsonProperty(value="messages")
    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompatibilityCheckResponse that = (CompatibilityCheckResponse)o;
        return this.isCompatible == that.isCompatible;
    }

    public int hashCode() {
        return Objects.hash(this.isCompatible);
    }
}

