/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Context;
import io.confluent.kafka.schemaregistry.json.diff.Difference;
import java.util.Objects;
import org.everit.json.schema.StringSchema;

class StringSchemaDiff {
    StringSchemaDiff() {
    }

    static void compare(Context ctx2, StringSchema original, StringSchema update) {
        if (!Objects.equals(original.getMaxLength(), update.getMaxLength())) {
            if (original.getMaxLength() == null && update.getMaxLength() != null) {
                ctx2.addDifference("maxLength", Difference.Type.MAX_LENGTH_ADDED);
            } else if (original.getMaxLength() != null && update.getMaxLength() == null) {
                ctx2.addDifference("maxLength", Difference.Type.MAX_LENGTH_REMOVED);
            } else if (original.getMaxLength() < update.getMaxLength()) {
                ctx2.addDifference("maxLength", Difference.Type.MAX_LENGTH_INCREASED);
            } else if (original.getMaxLength() > update.getMaxLength()) {
                ctx2.addDifference("maxLength", Difference.Type.MAX_LENGTH_DECREASED);
            }
        }
        if (!Objects.equals(original.getMinLength(), update.getMinLength())) {
            if (original.getMinLength() == null && update.getMinLength() != null) {
                ctx2.addDifference("minLength", Difference.Type.MIN_LENGTH_ADDED);
            } else if (original.getMinLength() != null && update.getMinLength() == null) {
                ctx2.addDifference("minLength", Difference.Type.MIN_LENGTH_REMOVED);
            } else if (original.getMinLength() < update.getMinLength()) {
                ctx2.addDifference("minLength", Difference.Type.MIN_LENGTH_INCREASED);
            } else if (original.getMinLength() > update.getMinLength()) {
                ctx2.addDifference("minLength", Difference.Type.MIN_LENGTH_DECREASED);
            }
        }
        if (original.getPattern() == null && update.getPattern() != null) {
            ctx2.addDifference("pattern", Difference.Type.PATTERN_ADDED);
        } else if (original.getPattern() != null && update.getPattern() == null) {
            ctx2.addDifference("pattern", Difference.Type.PATTERN_REMOVED);
        } else if (original.getPattern() != null && update.getPattern() != null && !original.getPattern().pattern().equals(update.getPattern().pattern())) {
            ctx2.addDifference("pattern", Difference.Type.PATTERN_CHANGED);
        }
    }
}

